/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.format;

import com.ibm.jvm.dump.format.CTypeObject;
import com.ibm.jvm.dump.format.DvAddress;
import com.ibm.jvm.dump.format.DvAddressException;
import com.ibm.jvm.dump.format.DvAddressSpace;
import com.ibm.jvm.dump.format.DvConsole;
import com.ibm.jvm.dump.format.DvDump;
import com.ibm.jvm.dump.format.DvProcess;
import com.ibm.jvm.dump.format.DvThread;
import com.ibm.jvm.dump.format.DvUtils;
import java.util.Hashtable;
import java.util.Vector;

public class DvThreadDetails {
    private static Hashtable threadsBySysthr;
    private static Hashtable threadsById;
    private static Hashtable threadsByEe;
    private static Vector threadList;
    private static DvAddressSpace as;
    public static DvThreadDetails that;

    public DvThreadDetails() {
        that = this;
        as = (DvAddressSpace)DvUtils.getAPT(DvConsole.theDump, "A");
    }

    public static void processThreads() {
        DvUtils.writetoTrace("Entry:DvThreadDetails.processThreads");
        if (0 != threadList.size()) {
            return;
        }
        DvDump dvDump = DvConsole.getCurrentDump();
        as = (DvAddressSpace)DvUtils.getAPT(dvDump, "A");
        DvAddress dvAddress = null;
        DvProcess[] dvProcessArray = as.getProcesses();
        for (int i = 0; i < dvProcessArray.length; ++i) {
            DvThread[] dvThreadArray = dvProcessArray[i].getThreads();
            threadsBySysthr = new Hashtable(dvThreadArray.length);
            threadsById = new Hashtable(dvThreadArray.length);
            threadsByEe = new Hashtable(dvThreadArray.length);
            for (int j = 0; j < dvThreadArray.length; ++j) {
                if (dvThreadArray[j].isJava()) {
                    long l;
                    CTypeObject cTypeObject = new CTypeObject("execenv", dvThreadArray[j].eeAddress(), as);
                    if (cTypeObject == null || as == null || dvThreadArray[j] == null) {
                        DvUtils.writetoTrace("Exit:1 DvThreadDetails.processThreads unexpected NULL variable");
                        return;
                    }
                    if (dvThreadArray[j].eeAddress().getAddressAsLong() == 0L) {
                        DvUtils.writetoTrace("Exit 2: DvThreadDetails.processThreads");
                        return;
                    }
                    CTypeObject cTypeObject2 = null;
                    cTypeObject2 = cTypeObject.getField("lk_thread_local.lk.flc");
                    CTypeObject cTypeObject3 = cTypeObject2.getField("thread_ident");
                    if (cTypeObject3 == null) {
                        DvUtils.writetoTrace("Warning: DvThreadDetails.processThreads unexpected NULL variable");
                        continue;
                    }
                    try {
                        dvAddress = as.readPointer(as.createAddress(cTypeObject3.getAddr()));
                    }
                    catch (DvAddressException dvAddressException) {
                        DvUtils.writetoTrace("Warning:2 DvThreadDetails.processThreads() DvAddressException getThreadName");
                    }
                    if (null != dvAddress) {
                        l = dvAddress.getAddressAsLong();
                    } else {
                        l = 0L;
                        DvUtils.trace("*** Unexpected event in DvThreadDetails.processThreads() \n for thread " + dvThreadArray[j].id() + "(" + dvThreadArray[j].getThreadName(as) + ")" + "\nMight be worthy of further investigation", 0, true);
                    }
                    if (l == 0L) continue;
                    String string = dvThreadArray[j].getThreadName(as);
                    CTypeObject cTypeObject4 = cTypeObject.getField("sys_thr");
                    ThreadDetails threadDetails = new ThreadDetails(l >> 16, string, cTypeObject.getAddr(), cTypeObject4.getAddr(), dvThreadArray[j].id());
                    threadList.add(threadDetails);
                    long l2 = cTypeObject4.getAddr();
                    threadsBySysthr.put(Long.toHexString(l2), threadDetails);
                    threadsById.put(Long.toHexString(threadDetails.thread_ident), threadDetails);
                    threadsByEe.put(Long.toHexString(threadDetails.getEE()), threadDetails);
                    continue;
                }
                DvUtils.writetoTrace("Warning:DvThreadDetails.processThreads non-Java thread");
            }
        }
        DvUtils.writetoTrace("Warning: DvThreadDetails.processThreads unexpected exception");
    }

    public static Object getThreadDetailsById(String string) {
        Object v = threadsById.get(string);
        return v;
    }

    public static Object getThreadDetailsByEe(String string) {
        Object v = threadsByEe.get(string);
        return v;
    }

    public static Object getThreadDetailsByPosition(int n) {
        Object e = threadList.get(n);
        return e;
    }

    public static Object getThreadDetailsBySysthr(String string) {
        Object v = threadsBySysthr.get(string);
        return v;
    }

    public static void addBlockingThread(Object object, Object object2) {
        ((ThreadDetails)object).addBlockingThread((ThreadDetails)object2);
    }

    public static String getThreadID(Object object) {
        String string = " -unknown-";
        try {
            string = DvUtils.rJustify("0x" + ((ThreadDetails)object).getThreadID(), 10);
            string = string.trim();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getThreadID", object, exception);
        }
        return string;
    }

    public static long getThreadIdent(Object object) {
        long l = -1L;
        try {
            l = ((ThreadDetails)object).getThreadIdent();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getThreadIdent", object, exception);
        }
        return l;
    }

    public static long getWaitMon(Object object) {
        long l = 0L;
        try {
            l = ((ThreadDetails)object).getWaitMon();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getWaitMon", object, exception);
        }
        return l;
    }

    public static void addWaitMon(Object object, long l) {
        try {
            ((ThreadDetails)object).addWaitMon(l);
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("addWaitMon", object, exception);
        }
    }

    public static long getSysThr(Object object) {
        long l = -1L;
        try {
            l = ((ThreadDetails)object).getSysThr();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getSysThr", object, exception);
        }
        return l;
    }

    public static long getEnterMon(Object object) {
        long l = 0L;
        try {
            l = ((ThreadDetails)object).getEnterMon();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getEnterMon", object, exception);
        }
        return l;
    }

    public static long getEE(Object object) {
        long l = -1L;
        try {
            l = ((ThreadDetails)object).getEE();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getEE", object, exception);
        }
        return l;
    }

    public static void incDeadlocked(Object object) {
        try {
            ((ThreadDetails)object).incDeadlocked();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("incDeadlocked", object, exception);
        }
    }

    public static void decDeadlocked(Object object) {
        try {
            ((ThreadDetails)object).decDeadlocked();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("decDeadlocked", object, exception);
        }
    }

    public static Object getBlockingThread(Object object) {
        ThreadDetails threadDetails = null;
        try {
            threadDetails = ((ThreadDetails)object).getBlockingThread();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getBlockingThread", object, exception);
        }
        return threadDetails;
    }

    public static int getDeadlocked(Object object) {
        int n = 4;
        try {
            n = ((ThreadDetails)object).getDeadlocked();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getDeadlocked", object, exception);
        }
        return n;
    }

    public static boolean getProcessed(Object object) {
        boolean bl = false;
        try {
            bl = ((ThreadDetails)object).getProcessed();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getProcessed", object, exception);
        }
        return bl;
    }

    public static void setProcessed(Object object, boolean bl) {
        try {
            ((ThreadDetails)object).setProcessed(true);
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("setProcessed", object, exception);
        }
    }

    public static String getThreadName(Object object) {
        String string = " -unknown-";
        try {
            string = ((ThreadDetails)object).getThreadName();
        }
        catch (Exception exception) {
            DvThreadDetails.handleException("getThreadName", object, exception);
        }
        return string;
    }

    public static int getThreadCount() {
        return threadList.size();
    }

    public static Object createThreadDetails(long l, String string, long l2, long l3, String string2) {
        ThreadDetails threadDetails = new ThreadDetails(l, string, l2, l3, string2);
        return threadDetails;
    }

    private static void handleException(String string, Object object, Exception exception) {
        DvUtils.trace("*** Exception in " + string + " for" + object.toString(), 0, true);
        DvUtils.trace(" Stack: " + exception.toString(), 0, true);
    }

    static {
        threadList = new Vector();
        as = null;
        that = null;
    }

    private static class ThreadDetails {
        private long thread_ident = 0L;
        private String thread_name = null;
        private long execenv = 0L;
        private long sys_thr = 0L;
        private String thread_ID = null;
        private long monEnterAddr = 0L;
        private long monWaitAddr = 0L;
        private Vector monitorsOwned = new Vector();
        private ThreadDetails blockingThread = null;
        private boolean processed = false;
        private int deadlocked = 0;

        public ThreadDetails(long l, String string, long l2, long l3, String string2) {
            this.thread_ident = l;
            this.thread_name = string;
            this.execenv = l2;
            this.sys_thr = l3;
            this.thread_ID = string2;
            switch (DvConsole.theDump.getSystemType()) {
                case 1: {
                    if (l3 == 0L) break;
                    this.monEnterAddr = DvUtils.getControlBlockField("sys_thread", "enter_monitor", l3, as);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: 
                case 3: {
                    if (l3 == 0L) break;
                    this.monEnterAddr = DvUtils.getControlBlockField("sys_thread", "mon_enter", l3, as);
                    break;
                }
            }
        }

        public ThreadDetails(long l, String string) {
            this(0L, string, 0L, l, null);
        }

        public long getThreadIdent() {
            return this.thread_ident;
        }

        public String getThreadName() {
            return this.thread_name;
        }

        public long getEE() {
            return this.execenv;
        }

        public long getSysThr() {
            return this.sys_thr;
        }

        public long getEnterMon() {
            return this.monEnterAddr;
        }

        public long getWaitMon() {
            return this.monWaitAddr;
        }

        public void addWaitMon(long l) {
            this.monWaitAddr = l;
        }

        public String getThreadID() {
            ThreadDetails threadDetails;
            if (null == this.thread_ID && 0L != this.sys_thr && (threadDetails = (ThreadDetails)threadsBySysthr.get(Long.toHexString(this.sys_thr))) != null) {
                this.thread_ID = threadDetails.getThreadID();
                return this.thread_ID;
            }
            return this.thread_ID;
        }

        public void addBlockingThread(ThreadDetails threadDetails) {
            this.blockingThread = threadDetails;
        }

        public ThreadDetails getBlockingThread() {
            return this.blockingThread;
        }

        public void incDeadlocked() {
            ++this.deadlocked;
        }

        public void decDeadlocked() {
            --this.deadlocked;
        }

        public int getDeadlocked() {
            return this.deadlocked;
        }

        public boolean getProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean bl) {
            this.processed = bl;
        }

        public String toString() {
            return "thread name " + this.thread_name + " execenv " + Long.toHexString(this.execenv);
        }
    }
}

