/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;
import java.util.StringTokenizer;

class JVMModule
extends Segment {
    long fileOffset;
    long hpiInfo;
    long threadQueue;
    long threadNum;
    long threadNext;
    long execEnvOffset;
    long pidOffset;
    long tidOffset;
    long pfmData;
    String dll;
    String commandLine;
    String executable;
    long jvmRas;

    JVMModule() {
    }

    JVMModule(Segment segment, long l, long l2) {
        super(segment.moduleName, segment.moduleAddress.getAddressAsLong(), segment.moduleSize, segment.moduleType, segment.reader, segment.offset);
        this.fileOffset = l;
        this.jvmRas = l2;
    }

    boolean populate() throws IOException {
        DvUtils.trace("populate JVMModule", 0, false);
        int n = (int)this.moduleSize;
        DvFileReader dvFileReader = (DvFileReader)this.reader;
        dvFileReader.setPos(this.fileOffset);
        long l = dvFileReader.readAddress();
        long l2 = dvFileReader.readAddress();
        long l3 = dvFileReader.readAddress();
        dvFileReader.setAddress(l3);
        String string = dvFileReader.readStringPtr();
        String string2 = dvFileReader.readStringPtr();
        this.dll = dvFileReader.readStringPtr();
        String string3 = dvFileReader.readStringPtr();
        String string4 = dvFileReader.readStringPtr();
        String string5 = dvFileReader.readStringPtr();
        this.commandLine = string5.endsWith("endorsed") ? dvFileReader.readStringPtr() : string5;
        StringTokenizer stringTokenizer = new StringTokenizer(this.commandLine, " ");
        if (stringTokenizer.hasMoreTokens()) {
            this.executable = stringTokenizer.nextToken();
        }
        DvUtils.trace("sysClassPath=" + string, 2, false);
        DvUtils.trace("libPath=" + string2, 2, false);
        DvUtils.trace("dll=" + this.dll, 2, false);
        DvUtils.trace("javaHome=" + string3, 2, false);
        DvUtils.trace("extdirs=" + string4, 2, false);
        DvUtils.trace("commandLine=" + this.commandLine, 2, false);
        return true;
    }
}

