/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.ElfHeader;
import com.ibm.jvm.dump.extract.Executable;
import com.ibm.jvm.dump.extract.MemoryMap;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.Sdff;
import com.ibm.jvm.dump.sdff.Segment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

class ExLoaded {
    static final long DT_NULL = 0L;
    static final long DT_DEBUG = 21L;
    Vector segment = new Vector();
    Executable executable;

    ExLoaded() {
    }

    ExLoaded(DvFileReader dvFileReader, Executable executable, MemoryMap memoryMap) throws IOException {
        if (executable == null) {
            return;
        }
        this.executable = executable;
        ElfHeader elfHeader = (ElfHeader)executable.header;
        executable.reader.setPos(elfHeader.programHeaderOffset);
        int n = 0;
        block0: while ((long)n < elfHeader.numProgramHeaders) {
            long l;
            long l2;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            executable.reader.setPos(elfHeader.programHeaderOffset + (long)n * elfHeader.programHeaderEntrySize);
            if (executable.reader.wordLength.size == 8) {
                l8 = executable.reader.readWord();
                l7 = executable.reader.readWord();
                l6 = executable.reader.readAddress();
                l5 = executable.reader.readAddress();
                l4 = executable.reader.readAddress();
                l3 = executable.reader.readLong();
                l2 = executable.reader.readLong();
                l = executable.reader.readLong();
            } else {
                l8 = executable.reader.readWord();
                l6 = executable.reader.readAddress();
                l5 = executable.reader.readAddress();
                l4 = executable.reader.readAddress();
                l3 = executable.reader.readWord();
                l2 = executable.reader.readWord();
                l7 = executable.reader.readWord();
                l = executable.reader.readWord();
            }
            DvUtils.trace("segment type = " + l8, 2, false);
            if (l8 == 2L) {
                long l9;
                long l10 = l5;
                DvUtils.trace("LoadedePtr=" + Long.toHexString(l10), 2, false);
                dvFileReader.setAddress(l10);
                while ((l9 = dvFileReader.readAddress()) != 0L) {
                    DvUtils.trace("tag=" + Long.toHexString(l9), 2, false);
                    if (l9 == 21L) {
                        l5 = dvFileReader.readAddress();
                        dvFileReader.setAddress(l5);
                        long l11 = dvFileReader.readWord();
                        if (dvFileReader.wordLength.size == 8) {
                            l = dvFileReader.readWord();
                        }
                        long l12 = dvFileReader.readAddress();
                        while (l12 != 0L) {
                            dvFileReader.setAddress(l12);
                            l5 = dvFileReader.readAddress();
                            DvUtils.trace("Pos1 = " + dvFileReader.getPos(), 2, false);
                            String string = dvFileReader.readStringPtr();
                            DvUtils.trace("Pos2 = " + dvFileReader.getPos(), 2, false);
                            long l13 = dvFileReader.readAddress();
                            long l14 = 0L;
                            DvUtils.trace("Address " + Long.toHexString(l5) + " Size " + Long.toHexString(l14) + " <" + string + ">" + " section = " + Long.toHexString(l13), 2, false);
                            if (l5 != 0L) {
                                Segment segment = memoryMap.getSegment(l5);
                                if (segment != null) {
                                    DvUtils.trace("Segment size is " + segment.moduleSize, 2, false);
                                    segment.moduleName = string;
                                } else {
                                    DvUtils.trace("Segment not found", 2, false);
                                    segment = new Segment(string, l5, l14, 1);
                                }
                                this.segment.add(segment);
                            }
                            l12 = dvFileReader.readAddress();
                            DvUtils.trace("Next " + Long.toHexString(l12), 2, false);
                        }
                        break block0;
                    }
                    l5 = dvFileReader.readAddress();
                    DvUtils.trace("address=" + Long.toHexString(l5), 2, false);
                }
                break;
            }
            ++n;
        }
    }

    void printSdff(Sdff sdff) throws IOException {
        DvUtils.trace("Printing Loaded", 2, false);
        sdff.align(4);
        long l = sdff.getFilePointer();
        sdff.writeLong(0L);
        sdff.writeBytes(new String("LOADED  "));
        Enumeration enumeration = this.segment.elements();
        while (enumeration.hasMoreElements()) {
            Segment segment = (Segment)enumeration.nextElement();
            sdff.writeLong(segment.moduleAddress.getAddressAsLong());
            sdff.writeLong(segment.moduleSize);
            sdff.writeLong(segment.moduleName.length());
            sdff.writeBytes(segment.moduleName);
            if (segment.moduleName.length() % 8 == 0) continue;
            byte[] byArray = new byte[8 - segment.moduleName.length() % 8];
            sdff.write(byArray);
        }
        sdff.writeLong(-1L);
        sdff.printLength(l);
    }
}

