/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.Elf;
import com.ibm.jvm.dump.extract.ElfNoteIA32;
import com.ibm.jvm.dump.extract.ElfNoteIA64;
import com.ibm.jvm.dump.extract.ElfNotePPC;
import com.ibm.jvm.dump.extract.ElfNoteS390;
import com.ibm.jvm.dump.extract.ElfRegister;
import com.ibm.jvm.dump.extract.ElfType;
import com.ibm.jvm.dump.extract.ExProcess;
import com.ibm.jvm.dump.extract.ExThread;
import com.ibm.jvm.dump.format.DvUtils;
import java.io.IOException;

class ElfLinux
extends ElfType {
    ElfRegister elfRegister;
    int signal;
    static final int NT_PRSTATUS = 1;
    static final int NT_PRFPREG = 2;
    static final int NT_PRPSINFO = 3;
    static final int NT_TASKSTRUCT = 4;
    static final int NT_AUXV = 6;
    static final int NT_PRXFPREG = 1189489535;

    ElfLinux(Elf elf, int n) {
        super(elf);
        DvUtils.trace("Elf type Linux", 2, false);
        switch (n) {
            case 3: {
                this.elfRegister = new ElfNoteIA32();
                break;
            }
            case 50: {
                this.elfRegister = new ElfNoteIA64();
                break;
            }
            case 20: 
            case 21: {
                this.elfRegister = new ElfNotePPC();
                break;
            }
            case 22: {
                this.elfRegister = new ElfNoteS390();
                break;
            }
            default: {
                System.err.println("JVMRAS011: Unsupported machine type " + n + ".");
            }
        }
    }

    void readNote(int n, long l) throws IOException {
        switch (n) {
            case 1: {
                if (this.process == null) {
                    this.process = new ExProcess();
                }
                this.process.thread.add(new prStatus());
                break;
            }
            case 2: {
                this.reader.setPos(l);
                break;
            }
            case 1189489535: {
                this.reader.setPos(l);
                break;
            }
            case 3: {
                this.process = new PrPsInfo(this.process);
                break;
            }
            case 4: {
                this.reader.setPos(l);
                break;
            }
            case 6: {
                this.reader.setPos(l);
                break;
            }
            default: {
                System.err.println("JVMRAS012: Unexpected note type " + n + " found in " + "core file - ignored.");
                this.reader.setPos(l);
            }
        }
    }

    class PrPsInfo
    extends ExProcess {
        PrPsInfo(ExProcess exProcess) throws IOException {
            if (exProcess != null) {
                DvUtils.trace("Copy over values from the embryonic process", 2, false);
                this.pid = exProcess.pid;
                this.signalNumber = exProcess.signalNumber;
                this.thread = exProcess.thread;
            }
            byte[] byArray = new byte[ElfLinux.this.reader.wordLength.size];
            ElfLinux.this.reader.readBuffer(byArray);
            long l = byArray[0];
            long l2 = byArray[1];
            long l3 = byArray[2];
            long l4 = byArray[3];
            long l5 = ElfLinux.this.reader.readAddress();
            long l6 = ElfLinux.this.reader.readUid();
            long l7 = ElfLinux.this.reader.readUid();
            long l8 = ElfLinux.this.reader.readWord();
            long l9 = ElfLinux.this.reader.readWord();
            long l10 = ElfLinux.this.reader.readWord();
            long l11 = ElfLinux.this.reader.readWord();
            String string = ElfLinux.this.reader.readString(16).trim();
            String string2 = ElfLinux.this.reader.readString(80).trim();
            this.generateExecutable(string, string2);
            DvUtils.trace("state = " + Long.toHexString(l), 2, false);
            DvUtils.trace("sname = " + Long.toHexString(l2), 2, false);
            DvUtils.trace("zombie = " + Long.toHexString(l3), 2, false);
            DvUtils.trace("nice = " + Long.toHexString(l4), 2, false);
            DvUtils.trace("flags = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("uid = " + l6, 2, false);
            DvUtils.trace("gid = " + l7, 2, false);
            DvUtils.trace("pid = " + l8, 2, false);
            DvUtils.trace("ppid = " + l9, 2, false);
            DvUtils.trace("pgrp = " + Long.toHexString(l10), 2, false);
            DvUtils.trace("sid = " + Long.toHexString(l11), 2, false);
            DvUtils.trace("command = " + string, 2, false);
            DvUtils.trace("executable = " + this.executable, 2, false);
            DvUtils.trace("commandLine = " + string2, 2, false);
        }
    }

    class prStatus
    extends ExThread {
        prStatus() throws IOException {
            ElfLinux.this.process.signalNumber = ElfLinux.this.reader.readWord();
            long l = ElfLinux.this.reader.readWord();
            long l2 = ElfLinux.this.reader.readWord();
            long l3 = ElfLinux.this.reader.readHalf();
            long l4 = ElfLinux.this.reader.readHalf();
            long l5 = ElfLinux.this.reader.readAddress();
            long l6 = ElfLinux.this.reader.readAddress();
            ElfLinux.this.process.pid = ElfLinux.this.reader.readWord();
            long l7 = ElfLinux.this.reader.readWord();
            long l8 = ElfLinux.this.reader.readWord();
            long l9 = ElfLinux.this.reader.readWord();
            long l10 = ElfLinux.this.reader.readAddress();
            long l11 = ElfLinux.this.reader.readAddress();
            long l12 = ElfLinux.this.reader.readAddress();
            long l13 = ElfLinux.this.reader.readAddress();
            long l14 = ElfLinux.this.reader.readAddress();
            long l15 = ElfLinux.this.reader.readAddress();
            long l16 = ElfLinux.this.reader.readAddress();
            long l17 = ElfLinux.this.reader.readAddress();
            DvUtils.trace("signalNumber = " + ElfLinux.this.process.signalNumber, 2, false);
            DvUtils.trace("code = " + l, 2, false);
            DvUtils.trace("errno = " + l2, 2, false);
            DvUtils.trace("cursig = " + l3, 2, false);
            DvUtils.trace("pending = " + Long.toHexString(l5), 2, false);
            DvUtils.trace("blocked = " + Long.toHexString(l6), 2, false);
            DvUtils.trace("pid = " + ElfLinux.this.process.pid, 2, false);
            DvUtils.trace("ppid = " + l7, 2, false);
            DvUtils.trace("pgroup = " + l8, 2, false);
            DvUtils.trace("session = " + l9, 2, false);
            DvUtils.trace("utime = " + l10 + "." + l11, 2, false);
            DvUtils.trace("stime = " + l12 + "." + l13, 2, false);
            DvUtils.trace("cutime = " + l14 + "." + l15, 2, false);
            DvUtils.trace("cstime = " + l16 + "." + l17, 2, false);
            ElfLinux.this.elfRegister.read(ElfLinux.this.reader, this);
        }
    }
}

