/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dump.extract;

import com.ibm.jvm.dump.extract.AIXCore;
import com.ibm.jvm.dump.extract.AIXThread;
import com.ibm.jvm.dump.extract.AIXUserx;
import com.ibm.jvm.dump.format.DvUtils;
import com.ibm.jvm.dump.sdff.DvFileReader;
import com.ibm.jvm.dump.sdff.SDFFDump;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class AIXCoreHeader
extends SDFFDump {
    DvFileReader reader;
    long c_signo;
    long c_flag;
    static final long FULL_CORE = 1L;
    static final long CORE_VERSION_1 = 2L;
    static final long MSTS_VALID = 4L;
    static final long CORE_BIGDATA = 8L;
    static final long UBLOCK_VALID = 16L;
    static final long USTACK_VALID = 32L;
    static final long LE_VALID = 64L;
    static final long CORE_TRUNC = 128L;
    long c_entries;
    long c_version;
    long c_fdsinfox;
    long c_loader;
    long c_lsize;
    long c_n_thr;
    long c_thr;
    long c_segs;
    long c_segregion;
    long c_stack;
    long c_stackorg;
    long c_stacksize;
    long c_stackend;
    long c_data;
    long c_dataorg;
    long c_datasize;
    long c_dataend;
    long c_sdorg;
    long c_sdsize;
    long c_sdend;
    long c_vmregions;
    long c_vmm;
    long c_impl;
    static int POWER_RS1 = 1;
    static int POWER_RSC = 2;
    static int POWER_RS2 = 4;
    static int POWER_601 = 8;
    static int POWER_603 = 32;
    static int POWER_604 = 16;
    static int POWER_620 = 64;
    static int POWER_630 = 128;
    static int POWER_A35 = 256;
    static int POWER_RS64II = 512;
    static int POWER_RS64III = 1024;
    static int POWER_4 = 2048;
    static int POWER_MPC7450 = 4096;
    long c_pad;
    long c_cprs;
    long[] c_reserved = new long[7];
    AIXThread c_flt;
    AIXUserx c_u;
    Vector threadVector;
    Vector sysThreadVector;
    AIXCore layout;
    byte[] CStringBuf = new byte[1024];

    public AIXCoreHeader(AIXCore aIXCore) throws IOException {
        Object object;
        this.layout = aIXCore;
        this.reader = aIXCore.getReader();
        this.c_signo = this.reader.readByte();
        this.c_flag = this.reader.readByte();
        if ((this.c_flag & 0x80L) != 0L) {
            throw new RuntimeException("Core file is truncated\nwhich means it cannot be successfully extracted\nPlease check free space and user limits, then attempt to recreate the problem.\n***This dump will NOT be adequate for problem determination.***");
        }
        this.c_entries = this.reader.readHalf();
        this.c_version = this.reader.readWord();
        this.c_fdsinfox = this.reader.readLong();
        this.c_loader = this.reader.readLong();
        this.c_lsize = this.reader.readLong();
        this.c_n_thr = this.reader.readWord();
        this.skipBytes(4L);
        this.c_thr = this.reader.readLong();
        this.c_segs = this.reader.readLong();
        this.c_segregion = this.reader.readLong();
        this.c_stack = this.reader.readLong();
        this.c_stackorg = this.reader.readLong();
        this.c_stacksize = this.reader.readLong();
        this.c_stackend = this.c_stackorg + this.c_stacksize;
        this.c_data = this.reader.readLong();
        this.c_dataorg = this.reader.readLong();
        this.c_datasize = this.reader.readLong();
        this.c_dataend = this.c_dataorg + this.c_datasize;
        this.c_sdorg = this.reader.readLong();
        this.c_sdsize = this.reader.readLong();
        this.c_sdend = this.c_sdorg + this.c_sdsize;
        this.c_vmregions = this.reader.readLong();
        this.c_vmm = this.reader.readLong();
        this.c_impl = this.reader.readWord();
        this.c_pad = this.reader.readWord();
        this.c_cprs = this.reader.readLong();
        for (int i = 0; i < this.c_reserved.length; ++i) {
            this.c_reserved[i] = this.reader.readLong();
        }
        this.c_flt = new AIXThread(aIXCore);
        this.c_u = new AIXUserx(aIXCore);
        this.threadVector = new Vector();
        this.threadVector.add(this.c_flt);
        if (this.c_n_thr > 0L) {
            this.getThreadData(this.threadVector);
        }
        this.setArchitecture(this.reader.wordLength, this.reader.endType);
        system = 2;
        subsystem = -1;
        processor = 2;
        String string = null;
        String string2 = "/usr/lpp/bos/aix_release.level";
        try {
            object = new BufferedReader(new FileReader(string2));
            string = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            System.err.println("JVMRAS030: Could not read AIX version file '" + string2 + "' - continuing to extract.");
        }
        if (string != null) {
            object = new StringTokenizer(string, ".");
            if (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                if (string3.equals("4")) {
                    subsystem = 12;
                } else if (string3.equals("5") && ((StringTokenizer)object).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object).nextToken();
                    if (string4.equals("1")) {
                        subsystem = 7;
                    } else if (string4.equals("2")) {
                        subsystem = 8;
                    } else if (string4.equals("3")) {
                        subsystem = 13;
                    }
                }
            }
            if (subsystem == -1) {
                System.err.println("JVMRAS031: Unexpected AIX version '" + string + "' found - continuing to extract.");
            }
        }
    }

    void getThreadData(Vector vector) throws IOException {
        this.reader.setPos(this.c_thr);
        int n = 0;
        while ((long)n < this.c_n_thr) {
            AIXThread aIXThread = new AIXThread(this.layout);
            vector.add(aIXThread);
            ++n;
        }
    }

    public void dump() {
        DvUtils.trace("Signal was " + this.c_signo, 2, false);
        DvUtils.trace("Flag is  0x" + Long.toHexString(this.c_flag), 2, false);
        DvUtils.trace((this.c_flag & 1L) != 0L ? "FULL_CORE" : "not FULL_CORE", 2, false);
        DvUtils.trace((this.c_flag & 2L) != 0L ? "CORE_VERSION_1" : "not CORE_VERSION_1", 2, false);
        DvUtils.trace((this.c_flag & 4L) != 0L ? "MSTS_VALID" : "not MSTS_VALID", 2, false);
        DvUtils.trace((this.c_flag & 8L) != 0L ? "CORE_BIGDATA" : "not CORE_BIGDATA", 2, false);
        DvUtils.trace((this.c_flag & 0x10L) != 0L ? "UBLOCK_VALID" : "not UBLOCK_VALID", 2, false);
        DvUtils.trace((this.c_flag & 0x20L) != 0L ? "USTACK_VALID" : "not USTACK_VALID", 2, false);
        DvUtils.trace((this.c_flag & 0x40L) != 0L ? "LE_VALID" : "not LE_VALID", 2, false);
        DvUtils.trace((this.c_flag & 0x80L) != 0L ? "CORE_TRUNC" : "not CORE_TRUNC", 2, false);
        DvUtils.trace("c_entries = 0x" + Long.toHexString(this.c_entries), 2, false);
        if (this.c_entries != 0L) {
            throw new RuntimeException("Old format core file - not supported");
        }
        DvUtils.trace("c_version = 0x" + Long.toHexString(this.c_version), 2, false);
        DvUtils.trace("c_fdsinfox = 0x" + Long.toHexString(this.c_fdsinfox), 2, false);
        DvUtils.trace("c_loader = 0x" + Long.toHexString(this.c_loader), 2, false);
        DvUtils.trace("c_lsize = 0x" + Long.toHexString(this.c_lsize), 2, false);
        DvUtils.trace("c_n_thr = 0x" + Long.toHexString(this.c_n_thr), 2, false);
        DvUtils.trace("c_thr = 0x" + Long.toHexString(this.c_thr), 2, false);
        DvUtils.trace("c_segs = 0x" + Long.toHexString(this.c_segs), 2, false);
        DvUtils.trace("c_segregion = 0x" + Long.toHexString(this.c_segregion), 2, false);
        DvUtils.trace("c_stack = 0x" + Long.toHexString(this.c_stack), 2, false);
        DvUtils.trace("c_stackorg = 0x" + Long.toHexString(this.c_stackorg), 2, false);
        DvUtils.trace("c_size = 0x" + Long.toHexString(this.c_stacksize), 2, false);
        DvUtils.trace("c_stackend = 0x" + Long.toHexString(this.c_stackend), 2, false);
        DvUtils.trace("c_data = 0x" + Long.toHexString(this.c_data), 2, false);
        DvUtils.trace("c_dataorg = 0x" + Long.toHexString(this.c_dataorg), 2, false);
        DvUtils.trace("c_datasize = 0x" + Long.toHexString(this.c_datasize), 2, false);
        DvUtils.trace("c_dataend = 0x" + Long.toHexString(this.c_dataend), 2, false);
        DvUtils.trace("c_sdorg = 0x" + Long.toHexString(this.c_sdorg), 2, false);
        DvUtils.trace("c_sdsize = 0x" + Long.toHexString(this.c_sdsize), 2, false);
        DvUtils.trace("c_sdend = 0x" + Long.toHexString(this.c_sdend), 2, false);
        DvUtils.trace("c_vmregions = 0x" + Long.toHexString(this.c_vmregions), 2, false);
        DvUtils.trace("c_vmm = 0x" + Long.toHexString(this.c_vmm), 2, false);
        DvUtils.trace("c_impl = 0x" + Long.toHexString(this.c_impl), 2, false);
        if ((this.c_impl & (long)POWER_RS1) != 0L) {
            DvUtils.trace("\tRS1 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_RSC) != 0L) {
            DvUtils.trace("\tRSC class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_RS2) != 0L) {
            DvUtils.trace("\tRS2 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_601) != 0L) {
            DvUtils.trace("\t601 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_603) != 0L) {
            DvUtils.trace("\t603 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_604) != 0L) {
            DvUtils.trace("\t604 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_620) != 0L) {
            DvUtils.trace("\t620 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_630) != 0L) {
            DvUtils.trace("\t630 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_A35) != 0L) {
            DvUtils.trace("\tA35 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_RS64II) != 0L) {
            DvUtils.trace("\tRS64-II class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_RS64III) != 0L) {
            DvUtils.trace("\tRS64-III class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_4) != 0L) {
            DvUtils.trace("\t4 class CPU", 2, false);
        }
        if ((this.c_impl & (long)POWER_MPC7450) != 0L) {
            DvUtils.trace("\tMPC7450 class CPU", 2, false);
        }
        DvUtils.trace("c_cprs = 0x" + Long.toHexString(this.c_cprs), 2, false);
        this.c_flt.dump();
        this.c_u.dump();
        DvUtils.trace("Threads:", 2, false);
        Iterator iterator = this.threadVector.iterator();
        while (iterator.hasNext()) {
            ((AIXThread)iterator.next()).dump();
        }
    }

    String readCString() throws IOException {
        int n = 0;
        while (n < this.CStringBuf.length) {
            try {
                long l = this.reader.readByte();
                if (l == 0L) break;
                this.CStringBuf[n++] = (byte)l;
            }
            catch (EOFException eOFException) {
                // empty catch block
                break;
            }
        }
        if (n > 0) {
            return new String(this.CStringBuf, 0, n);
        }
        return null;
    }

    void goTo(long l) throws IOException {
        this.reader.setPos(this.addressToOffset(l));
    }

    void skipBytes(long l) throws IOException {
        this.reader.setPos(this.reader.getPos() + l);
    }

    long readLongAt(long l) throws IOException {
        this.goTo(l);
        return this.reader.readLong();
    }

    long readWordAt(long l) throws IOException {
        this.goTo(l);
        return this.reader.readWord();
    }

    long readAddressAt(long l) throws IOException {
        this.goTo(l);
        return this.reader.readAddress();
    }

    long addressToOffset(long l) {
        if (l >= this.c_dataorg && l < this.c_dataend) {
            return this.c_data + (l - this.c_dataorg);
        }
        return 0L;
    }
}

