/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.CORBA.iiop.PartnerVersion;
import com.ibm.rmi.io.ClassDescription;
import com.ibm.rmi.io.ValueUtility;
import com.ibm.rmi.util.RepositoryId;
import org.omg.CORBA.ValueMember;

public class ValueMemberWrapper
implements ClassDescription {
    private ValueMember vm;
    private int typeCode;
    private boolean isPrimitive;

    public ValueMemberWrapper(ValueMember valueMember) {
        this.setValueMember(valueMember);
    }

    public ValueMemberWrapper() {
    }

    public void setValueMember(ValueMember valueMember) {
        this.vm = valueMember;
        this.typeCode = valueMember.type.kind().value();
        this.isPrimitive = true;
        switch (this.typeCode) {
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 23: 
            case 26: {
                break;
            }
            default: {
                this.isPrimitive = false;
            }
        }
    }

    public void reset() {
        this.vm = null;
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public Class getType() {
        Class clazz = null;
        try {
            RepositoryId repositoryId = RepositoryId.cache.getId(this.vm.id);
            clazz = repositoryId.getClassFromType();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz;
    }

    public boolean isAny() {
        if (this.typeCode == 11 || this.typeCode == 21) {
            return true;
        }
        if (this.typeCode != 30) {
            return false;
        }
        String string = null;
        try {
            string = ValueUtility.getSignature(this.vm);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return string.equals("Ljava/lang/Object;") || string.equals("Ljava/io/Serializable;") || string.equals("Ljava/io/Externalizable;");
    }

    public boolean isValueType(PartnerVersion partnerVersion) {
        if (this.typeCode == 29) {
            return true;
        }
        if (this.typeCode != 30) {
            return false;
        }
        return !this.isRemoteInterface() && !this.isAbstractInterface(partnerVersion) && !this.isAny();
    }

    public boolean isRemoteInterface() {
        return this.typeCode == 14;
    }

    public boolean isAbstractInterface(PartnerVersion partnerVersion) {
        return this.typeCode == 32;
    }
}

