/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.corba.TCUtility;
import com.ibm.rmi.corba.TypeCodeImpl;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.io.ValueUtility;
import java.io.Serializable;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class AnyImpl
extends Any {
    private TypeCodeImpl typeCode;
    protected ORB orb;
    private CDRInputStream stream;
    private long value;
    private java.lang.Object object;
    private static TypeCodeImpl cachedBoxTypeCode;
    private static final int DEFAULT_BUFFER_SIZE = 32;
    private CDROutputStream lastOutputStream;
    private static final boolean[] isStreamed;

    public AnyImpl(ORB oRB) {
        this.orb = oRB;
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_null);
        this.stream = null;
        this.object = null;
        this.value = 0L;
    }

    public AnyImpl(ORB oRB, Any any) {
        this(oRB);
        if (any instanceof AnyImpl) {
            AnyImpl anyImpl = (AnyImpl)any;
            this.typeCode = anyImpl.typeCode;
            this.value = anyImpl.value;
            this.object = anyImpl.object;
            if (anyImpl.stream != null) {
                this.stream = (CDRInputStream)anyImpl.stream.dup();
            }
        } else {
            this.read_value(any.create_input_stream(), any.type());
        }
    }

    public TypeCode type() {
        return this.typeCode;
    }

    public void type(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        this.stream = null;
        this.value = 0L;
        this.object = null;
    }

    public boolean equal(Any any) {
        if (!this.typeCode.equal(any.type())) {
            return false;
        }
        switch (this.typeCode.kind().value()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == any.extract_short();
            }
            case 3: {
                return this.extract_long() == any.extract_long();
            }
            case 4: {
                return this.extract_ushort() == any.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == any.extract_ulong();
            }
            case 6: {
                return this.extract_float() == any.extract_float();
            }
            case 7: {
                return this.extract_double() == any.extract_double();
            }
            case 8: {
                return this.extract_boolean() == any.extract_boolean();
            }
            case 9: {
                return this.extract_char() == any.extract_char();
            }
            case 10: {
                return this.extract_octet() == any.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(any.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(any.extract_TypeCode());
            }
            case 18: {
                return this.extract_string().equals(any.extract_string());
            }
            case 23: {
                return this.extract_longlong() == any.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == any.extract_ulonglong();
            }
            case 17: {
                return this.create_input_stream().read_long() == any.create_input_stream().read_long();
            }
            case 25: {
                throw new NO_IMPLEMENT("LONG_DOUBLE_NOT_IMPLEMENTED (1) - TCKind._tk_longdouble", 1229124490, CompletionStatus.COMPLETED_NO);
            }
            case 26: {
                return this.extract_wchar() == any.extract_wchar();
            }
            case 27: {
                return this.extract_wstring().equals(any.extract_wstring());
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 30: {
                return this.compareComplexTypes(this, any);
            }
        }
        return false;
    }

    private boolean compareComplexTypes(Any any, Any any2) {
        if (any == any2) {
            return true;
        }
        if (any == null && any2 != null || any != null && any2 == null || any == null && any2 == null) {
            return false;
        }
        boolean bl = true;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (!any.type().equivalent(any2.type())) {
            bl = false;
        }
        if (bl) {
            org.omg.CORBA.portable.OutputStream outputStream = this.orb.create_output_stream();
            org.omg.CORBA.portable.OutputStream outputStream2 = this.orb.create_output_stream();
            any.write_value(outputStream);
            any2.write_value(outputStream2);
            byArray = ((CDROutputStream)outputStream).toByteArray();
            byArray2 = ((CDROutputStream)outputStream2).toByteArray();
            if (byArray == null || byArray2 == null) {
                bl = false;
            }
        }
        if (bl && byArray.length != byArray2.length) {
            bl = false;
        }
        if (bl) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        this.lastOutputStream = (CDROutputStream)this.orb.create_output_stream();
        return this.lastOutputStream;
    }

    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.stream != null) {
            return (CDRInputStream)this.stream.dup();
        }
        OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
        TCUtility.marshalIn((org.omg.CORBA.portable.OutputStream)outputStream, TCUtility.getRealTypeCode(this.typeCode).kind().value(), this.value, this.object);
        return outputStream.create_input_stream();
    }

    public void read_value(org.omg.CORBA.portable.InputStream inputStream, TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        int n = this.typeCode.kind().value();
        int n2 = TCUtility.getRealTypeCode(this.typeCode).kind().value();
        if (isStreamed[n2]) {
            if (inputStream instanceof CDRInputStream && ((CDRInputStream)inputStream).wasCreatedFrom(this.lastOutputStream)) {
                this.stream = (CDRInputStream)inputStream;
            } else {
                OutputStream outputStream = (OutputStream)this.orb.create_output_stream();
                this.typeCode.copy((InputStream)inputStream, outputStream);
                this.stream = (CDRInputStream)outputStream.create_input_stream();
            }
        } else {
            java.lang.Object[] objectArray = new java.lang.Object[]{this.object};
            long[] lArray = new long[1];
            TCUtility.unmarshalIn(inputStream, n2, lArray, objectArray);
            this.value = lArray[0];
            this.object = objectArray[0];
            this.stream = null;
            try {
                int n3;
                if ((n == 18 || n == 27) && (n3 = this.typeCode.length()) != 0 && ((String)this.object).length() > n3) {
                    throw new MARSHAL("erroneous bounded string - _tk_string | _tk_wstring", 1229125772, CompletionStatus.COMPLETED_NO);
                }
            }
            catch (BadKind badKind) {
                ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "read_value:485", (Exception)((java.lang.Object)badKind));
                throw new MARSHAL("(org.omg.CORBA.TypeCodePackage.BadKind)", 1229125773, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public void write_value(org.omg.CORBA.portable.OutputStream outputStream) {
        if (this.stream != null) {
            this.typeCode.copy((CDRInputStream)this.stream.dup(), (OutputStream)outputStream);
        } else {
            TCUtility.marshalIn(outputStream, TCUtility.getRealTypeCode(this.typeCode).kind().value(), this.value, this.object);
        }
    }

    public void insert_Streamable(Streamable streamable) {
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, streamable._type());
        this.object = streamable;
    }

    public void insert_short(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_short);
        this.value = s;
    }

    public short extract_short() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_short))) {
            throw new BAD_OPERATION("extracting short", 1229123969, CompletionStatus.COMPLETED_NO);
        }
        return (short)this.value;
    }

    public void insert_long(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_long);
        this.value = n;
    }

    public int extract_long() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_long))) {
            throw new BAD_OPERATION("extracting long", 1229123970, CompletionStatus.COMPLETED_NO);
        }
        return (int)this.value;
    }

    public void insert_ushort(short s) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort);
        this.value = s;
    }

    public short extract_ushort() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ushort))) {
            throw new BAD_OPERATION("extracting ushort", 1229123971, CompletionStatus.COMPLETED_NO);
        }
        return (short)this.value;
    }

    public void insert_ulong(int n) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong);
        this.value = n;
    }

    public int extract_ulong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulong))) {
            throw new BAD_OPERATION("extracting ulong", 1229123972, CompletionStatus.COMPLETED_NO);
        }
        return (int)this.value;
    }

    public void insert_float(float f) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_float);
        this.value = Float.floatToIntBits(f);
    }

    public float extract_float() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_float))) {
            throw new BAD_OPERATION("extracting float", 1229123973, CompletionStatus.COMPLETED_NO);
        }
        return Float.intBitsToFloat((int)this.value);
    }

    public void insert_double(double d) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_double);
        this.value = Double.doubleToLongBits(d);
    }

    public double extract_double() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_double))) {
            throw new BAD_OPERATION("extracting double", 1229123974, CompletionStatus.COMPLETED_NO);
        }
        return Double.longBitsToDouble(this.value);
    }

    public void insert_longlong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong);
        this.value = l;
    }

    public long extract_longlong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_longlong))) {
            throw new BAD_OPERATION("extracting longlong", 1229123975, CompletionStatus.COMPLETED_NO);
        }
        return this.value;
    }

    public void insert_ulonglong(long l) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong);
        this.value = l;
    }

    public long extract_ulonglong() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_ulonglong))) {
            throw new BAD_OPERATION("extracting ulonglong", 1229123976, CompletionStatus.COMPLETED_NO);
        }
        return this.value;
    }

    public void insert_boolean(boolean bl) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean);
        this.value = bl ? 1L : 0L;
    }

    public boolean extract_boolean() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_boolean))) {
            throw new BAD_OPERATION("extracting boolean", 1229123977, CompletionStatus.COMPLETED_NO);
        }
        return this.value != 0L;
    }

    public void insert_char(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_char);
        this.value = c;
    }

    public char extract_char() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_char))) {
            throw new BAD_OPERATION("extracting char", 1229123978, CompletionStatus.COMPLETED_NO);
        }
        return (char)this.value;
    }

    public void insert_wchar(char c) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar);
        this.value = c;
    }

    public char extract_wchar() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_wchar))) {
            throw new BAD_OPERATION("extracting wchar", 1229123980, CompletionStatus.COMPLETED_NO);
        }
        return (char)this.value;
    }

    public void insert_octet(byte by) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_octet);
        this.value = by;
    }

    public byte extract_octet() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_octet))) {
            throw new BAD_OPERATION("extracting octet", 1229123979, CompletionStatus.COMPLETED_NO);
        }
        return (byte)this.value;
    }

    public void insert_string(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_string);
        this.object = string;
    }

    public String extract_string() {
        if (this.typeCode.kind() != TCKind.tk_string) {
            throw new BAD_OPERATION("extracting string", 1229123981, CompletionStatus.COMPLETED_NO);
        }
        return (String)this.object;
    }

    public void insert_wstring(String string) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_wstring);
        this.object = string;
    }

    public String extract_wstring() {
        if (this.typeCode.kind() != TCKind.tk_wstring) {
            throw new BAD_OPERATION("extracting wstring", 1229123982, CompletionStatus.COMPLETED_NO);
        }
        return (String)this.object;
    }

    public void insert_any(Any any) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_any);
        this.object = any;
        this.stream = null;
    }

    public Any extract_any() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_any))) {
            throw new BAD_OPERATION("extracting any", 1229123983, CompletionStatus.COMPLETED_NO);
        }
        return (Any)this.object;
    }

    public void insert_Object(Object object) {
        if (object != null && object instanceof LocalObject) {
            throw new BAD_PARAM("LocalObjects cannot be passed to insert_Object", 1229124138, CompletionStatus.COMPLETED_NO);
        }
        if (object == null) {
            this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_objref);
        } else {
            TypeCode typeCode = ValueUtility.getTypeCode(this.orb, object);
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        }
        this.object = object;
    }

    public void insert_Object(Object object, TypeCode typeCode) {
        if (object != null && object instanceof LocalObject) {
            throw new BAD_PARAM("LocalObjects cannot be passed to insert_Object", 1229124138, CompletionStatus.COMPLETED_NO);
        }
        try {
            if (!typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") && !object._is_a(typeCode.id())) {
                throw new BAD_OPERATION("inserting Object (1)", 1229123984, CompletionStatus.COMPLETED_NO);
            }
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
            this.object = object;
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "insert_Object:982", exception);
            throw new BAD_OPERATION("inserting Object (2)", 1229123985, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object extract_Object() {
        Object object = null;
        try {
            object = (Object)this.object;
            if (this.typeCode.id().equals("IDL:omg.org/CORBA/Object:1.0") || object._is_a(this.typeCode.id())) {
                return object;
            }
            throw new BAD_OPERATION("extracting Object (1)", 1229123986, CompletionStatus.COMPLETED_NO);
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, (java.lang.Object)this, "extract_Object:1009", exception);
            throw new BAD_OPERATION("extracting Object (2)", 1229123987, CompletionStatus.COMPLETED_NO);
        }
    }

    public void insert_TypeCode(TypeCode typeCode) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode);
        this.object = typeCode;
    }

    public TypeCode extract_TypeCode() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_TypeCode))) {
            throw new BAD_OPERATION("extracting TypeCode", 1229123988, CompletionStatus.COMPLETED_NO);
        }
        return (TypeCode)this.object;
    }

    public void insert_Principal(Principal principal) {
        this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal);
        this.object = principal;
    }

    public Principal extract_Principal() {
        if (!this.typeCode.equal(TypeCodeImpl.get_primitive_tc(TCKind.tk_Principal))) {
            throw new BAD_OPERATION("extracting Principal", 1229123989, CompletionStatus.COMPLETED_NO);
        }
        return (Principal)this.object;
    }

    public Serializable extract_Value() throws BAD_OPERATION {
        int n = TCUtility.getRealTypeCode(this.typeCode).kind().value();
        if (n != 29 && n != 30 && n != 32) {
            throw new BAD_OPERATION("extracting Value (1)", 1229123990, CompletionStatus.COMPLETED_NO);
        }
        if (n == 32 && this.object instanceof Object) {
            throw new BAD_OPERATION("extracting Value (2)", 1229123990, CompletionStatus.COMPLETED_NO);
        }
        return (Serializable)this.object;
    }

    public void insert_Value(Serializable serializable) {
        this.object = serializable;
        if (serializable == null) {
            this.typeCode = TypeCodeImpl.get_primitive_tc(TCKind.tk_value);
        } else {
            TypeCode typeCode = ValueUtility.getTypeCode(this.orb, serializable);
            this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
        }
    }

    public void insert_Value(Serializable serializable, TypeCode typeCode) throws MARSHAL {
        this.object = serializable;
        this.typeCode = TypeCodeImpl.convertToNative(this.orb, typeCode);
    }

    static {
        isStreamed = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, true, true, true, false, true, true, true, true, false, false, false, false, false, false, false, false, false, false};
    }
}

