/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.cluster.adapter.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.selection.SelectionCriteria;
import com.ibm.wsspi.cluster.selection.SelectionService;
import com.ibm.wsspi.cluster.selection.SelectionServiceFactory;
import java.util.Map;

public final class ChannelSelectionCriteria
implements CFEndPointCriteria {
    private static final TraceComponent tc = Tr.register((Class)ChannelSelectionCriteria.class, (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final SelectionService selectionService = SelectionServiceFactory.getSelectionService();
    private final Identity clusterIdentity;
    private final SelectionCriteria criteria;
    private final CFEndPointCriteria cfEndPointCriteria;
    private final String chainName;
    private final Class accessor;
    private final Class[] channelFactories;
    private final boolean sslRequired;
    private String string = null;

    public ChannelSelectionCriteria(Identity identity, boolean bl, boolean bl2, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{identity, String.valueOf(bl), String.valueOf(bl2)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        this.criteria = selectionService.getCriteria(identity, bl, bl2, null, null);
        this.cfEndPointCriteria = cFEndPointCriteria;
        this.clusterIdentity = identity;
        this.chainName = cFEndPointCriteria == null ? null : cFEndPointCriteria.getChainName();
        this.accessor = cFEndPointCriteria == null ? null : cFEndPointCriteria.getChannelAccessor();
        this.channelFactories = cFEndPointCriteria == null ? null : cFEndPointCriteria.getOptionalChannelFactories();
        boolean bl3 = this.sslRequired = cFEndPointCriteria == null ? false : cFEndPointCriteria.isSSLRequired();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public ChannelSelectionCriteria(Identity identity, Map map, String string, Class clazz, Class[] classArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{identity, map, string, clazz, String.valueOf(bl)});
        }
        if (identity == null) {
            throw new IllegalArgumentException("The identity attribute must not be null.");
        }
        this.criteria = selectionService.getCriteria(identity, map);
        this.clusterIdentity = identity;
        this.chainName = string;
        this.accessor = clazz;
        this.channelFactories = classArray;
        this.sslRequired = bl;
        this.cfEndPointCriteria = this;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.cfEndPointCriteria;
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            stringBuffer.append(" [clusterIdentity=");
            stringBuffer.append(this.clusterIdentity);
            stringBuffer.append("] [criteria = ");
            stringBuffer.append(this.criteria);
            stringBuffer.append("] chainName=");
            stringBuffer.append(this.chainName);
            stringBuffer.append("] [sslRequired=");
            stringBuffer.append(this.sslRequired);
            stringBuffer.append("] [accessor=");
            stringBuffer.append(this.accessor);
            stringBuffer.append("] channelFactories=");
            if (this.channelFactories != null) {
                for (int i = 0; i < this.channelFactories.length; ++i) {
                    stringBuffer.append("[");
                    stringBuffer.append(this.channelFactories[i]);
                    stringBuffer.append("] ");
                }
            } else {
                stringBuffer.append("[null]");
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public Identity getIdentity() {
        return this.clusterIdentity;
    }

    public SelectionCriteria getCriteria() {
        return this.criteria;
    }

    public Class getChannelAccessor() {
        return this.accessor;
    }

    public String getChainName() {
        return this.chainName;
    }

    public Class[] getOptionalChannelFactories() {
        return this.channelFactories;
    }

    public boolean isSSLRequired() {
        return this.sslRequired;
    }
}

