/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.cluster.runtime.ApplicationServerRuntimeImpl;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.channel.framework.exception.NullCFEndPointException;
import com.ibm.wsspi.cluster.ClusterMemberService;
import com.ibm.wsspi.cluster.ClusterService;
import com.ibm.wsspi.cluster.ClusterServiceFactory;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class WLMChainEventListener
extends ComponentImpl
implements ChainEventListener {
    private static final TraceComponent tc = Tr.register((Class)WLMChainEventListener.class, (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMNLSMessages");
    private ChannelFrameworkService cfService;
    private ClusterService clusterService;
    private ClusterMemberService cms;
    private Map endpointCache = new HashMap();
    private Map endpointCacheforInprocess = new HashMap();
    private AdminService adminService;
    private String ivCellName = "";
    private String ivNodeName = "";
    private String ivProcessName = "";

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)new Object[]{object});
        }
        this.cms = (ClusterMemberService)this.getService(ClusterMemberService.class);
        ApplicationServerRuntimeImpl.setClusterMemberService(this.cms);
        this.cfService = (ChannelFrameworkService)this.getService(ChannelFrameworkService.class);
        if (this.cfService == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"initialize", (Object)"ChannelFrameworkService is unavailable.  Shutting down the ChainEventListener");
            }
            throw new ComponentDisabledException();
        }
        this.clusterService = ClusterServiceFactory.getClusterService();
        this.adminService = AdminServiceFactory.getAdminService();
        this.addService(WLMChainEventListener.class);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"start");
            }
            this.ivCellName = this.adminService.getCellName();
            this.ivNodeName = this.adminService.getNodeName();
            this.ivProcessName = this.adminService.getProcessName();
            try {
                this.cfService.addChainEventListener((ChainEventListener)this, "all_chains");
            }
            catch (ChainException chainException) {
                FFDCFilter.processException((Throwable)chainException, (String)(WLMChainEventListener.class.getName() + ".start"), (String)"155", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)((Object)chainException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stop");
            }
            try {
                this.cfService.removeChainEventListener((ChainEventListener)this, "all_chains");
            }
            catch (ChainException chainException) {
                FFDCFilter.processException((Throwable)chainException, (String)(WLMChainEventListener.class.getName() + ".stop"), (String)"176", (Object)((Object)this));
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)((Object)chainException));
            }
        }
        this.releaseService(WLMChainEventListener.class);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"chainStarted", (Object)new Object[]{chainData});
            }
            Identity identity = null;
            byte[] byArray = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream;
                CFEndPoint cFEndPoint;
                block15: {
                    cFEndPoint = this.cfService.getEndPoint(chainData.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"returned CFEndPoint:", (Object)cFEndPoint);
                    }
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeByte(0);
                        objectOutputStream.writeObject(cFEndPoint);
                        byArray = byteArrayOutputStream.toByteArray();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)(WLMChainEventListener.class.getName() + ".chainStarted"), (String)"225", (Object)((Object)this));
                        if (!tc.isDebugEnabled()) break block15;
                        Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)iOException);
                    }
                }
                identity = this.mapEndPointToIdentity(cFEndPoint);
                byteArrayOutputStream = null;
                if (cFEndPoint.isLocal()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"endpoint isLocal");
                    }
                    byteArrayOutputStream = this.cms.defineLocalScopedData(identity, byArray);
                    this.endpointCacheforInprocess.put(identity, byteArrayOutputStream);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Define member scope data ");
                    }
                    byteArrayOutputStream = this.cms.defineMemberScopedData(identity, byArray);
                    this.endpointCache.put(identity, byteArrayOutputStream);
                }
            }
            catch (ChainNotInboundException chainNotInboundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempted to start an outbound chain.  Only inbound chains be started.", (Object)chainData.getName());
                }
            }
            catch (NoCFEndPointException noCFEndPointException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempted to start a chain which includes a channel that does not implement the WSChannelFactory interface.", (Object)chainData.getName());
                }
            }
            catch (NullCFEndPointException nullCFEndPointException) {
                FFDCFilter.processException((Throwable)nullCFEndPointException, (String)(WLMChainEventListener.class.getName() + ".chainStarted"), (String)"254", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"WLMKEY_UNABLE_TO_RETRIEVE_CFENDPOINT", (Object)chainData.getName());
                if (!tc.isDebugEnabled()) break block16;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)((Object)nullCFEndPointException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chainStarted");
        }
    }

    public void chainStopped(ChainData chainData) {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"chainStopped", (Object)new Object[]{chainData});
            }
            try {
                CFEndPoint cFEndPoint = this.cfService.getEndPoint(chainData.getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"returned CFEndPoint:", (Object)cFEndPoint);
                }
                Identity identity = this.mapEndPointToIdentity(cFEndPoint);
                EndPoint endPoint = null;
                endPoint = cFEndPoint.isLocal() ? (EndPoint)this.endpointCacheforInprocess.remove(identity) : (EndPoint)this.endpointCache.remove(identity);
                if (endPoint != null) {
                    if (cFEndPoint.isLocal()) {
                        this.cms.undefineLocalScopedData(endPoint);
                    } else {
                        this.cms.undefineMemberScopedData(endPoint);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The EndPoint associated with chainName was not found in the WLM EndPoint cache.", (Object)chainData.getName());
                }
            }
            catch (ChainNotInboundException chainNotInboundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempted to start/stop an outbound chain.  Only inbound chains be started.", (Object)chainData.getName());
                }
            }
            catch (NoCFEndPointException noCFEndPointException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Attempted to start/stop a chain which includes a channel that does not implement the WSChannelFactory interface.", (Object)chainData.getName());
                }
            }
            catch (NullCFEndPointException nullCFEndPointException) {
                FFDCFilter.processException((Throwable)nullCFEndPointException, (String)(WLMChainEventListener.class.getName() + ".chainStopped"), (String)"316", (Object)((Object)this));
                Tr.error((TraceComponent)tc, (String)"WLMKEY_UNABLE_TO_RETRIEVE_CFENDPOINT", (Object)chainData);
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)((Object)nullCFEndPointException));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chainStopped");
        }
    }

    public void chainDestroyed(ChainData chainData) {
    }

    public void chainUpdated(ChainData chainData) {
    }

    private Identity mapEndPointToIdentity(CFEndPoint cFEndPoint) {
        Identity identity = null;
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("NAME", cFEndPoint.getName());
        treeMap.put("CELL", this.ivCellName);
        treeMap.put("NODE", this.ivNodeName);
        treeMap.put("SERVER", this.ivProcessName);
        treeMap.put("TYPE", "CHANNEL");
        treeMap.put("COMPONENT", "CF");
        identity = this.clusterService.getIdentity(treeMap);
        return identity;
    }
}

