/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;

public class ChannelTargetImpl
implements ChannelTarget {
    private static final TraceComponent tc = Tr.register((Class)ChannelTargetImpl.class, (String)"WLM", (String)"com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final Map distinction = new HashMap();
    private Target target;
    private CFEndPointCriteria criteria;
    private CFEndPoint[] cfEndpoints = null;
    private boolean inRetry = false;
    private EndPoint[] wlmEndPoints = null;
    private boolean postedNoHealthMonitorWarning = false;

    public ChannelTargetImpl(Target target, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ChannelTargetImpl", (Object)new Object[]{target, cFEndPointCriteria});
        }
        if (target == null) {
            throw new IllegalArgumentException("The Target passed in was null.");
        }
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria passed in was null.");
        }
        this.target = target;
        this.criteria = cFEndPointCriteria;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ChannelTargetImpl");
        }
    }

    public Identity getMemberIdentity() {
        return this.target.getMemberIdentity();
    }

    public Identity[] getClusterIdentities() {
        return this.target.getClusterIdentities();
    }

    public CFEndPoint getCFEndPoint() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCFEndPoint");
        }
        CFEndPoint cFEndPoint = null;
        if (this.cfEndpoints == null || this.inRetry) {
            this.wlmEndPoints = this.target.matchEndPoints(distinction);
            this.cfEndpoints = new CFEndPoint[this.wlmEndPoints.length];
            for (int i = 0; i < this.wlmEndPoints.length; ++i) {
                byte[] byArray = this.wlmEndPoints[i].getData();
                if (byArray == null) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"Unexpected: A null CFEndpoint was incorrectly given to WLM from the channel framework service. Some data may not be available for selection.", (Object)this.wlmEndPoints[i].getIdentity());
                    continue;
                }
                if (byArray.length == 0) {
                    if (!this.inRetry) {
                        block17: {
                            if (tc.isEventEnabled()) {
                                Tr.event((TraceComponent)tc, (String)"Unexpected: EndPoint is expected to have valid data and does not - sleeping 500ms to allow BB update to propagate, the retry", (Object)this.wlmEndPoints[i].getIdentity());
                            }
                            try {
                                this.inRetry = true;
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                if (!tc.isEventEnabled()) break block17;
                                Tr.event((TraceComponent)tc, (String)"Unexpected", (Object)interruptedException);
                            }
                        }
                        return this.getCFEndPoint();
                    }
                    if (!tc.isEventEnabled()) continue;
                    Tr.event((TraceComponent)tc, (String)"Already slept 500ms, and still do not have valid data - skipping this endpoint, and continuing", (Object)this.wlmEndPoints[i].getIdentity());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"byte array: ", (Object)new ByteArray(byArray));
                }
                ObjectInputStream objectInputStream = null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    objectInputStream.readByte();
                    this.cfEndpoints[i] = (CFEndPoint)objectInputStream.readObject();
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Adding endpoint to the array:", (Object)this.cfEndpoints[i]);
                    continue;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)((class$com$ibm$ws$cluster$channel$ChannelTargetImpl == null ? ChannelTargetImpl.class$("com.ibm.ws.cluster.channel.ChannelTargetImpl") : class$com$ibm$ws$cluster$channel$ChannelTargetImpl).getName() + ".getCFEndPoint"), (String)"145", (Object)this);
                    Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)((class$com$ibm$ws$cluster$channel$ChannelTargetImpl == null ? ChannelTargetImpl.class$("com.ibm.ws.cluster.channel.ChannelTargetImpl") : class$com$ibm$ws$cluster$channel$ChannelTargetImpl).getName() + ".getCFEndPoint"), (String)"149", (Object)this);
                    Tr.debug((TraceComponent)tc, (String)"unexpected exception ", (Object)classNotFoundException);
                }
            }
            if (this.inRetry) {
                this.inRetry = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"final size of the array:", (Object)String.valueOf(this.cfEndpoints.length));
                Tr.debug((TraceComponent)tc, (String)"final contents of array:", (Object)this.cfEndpoints);
            }
        }
        if (ChannelSelectionAdapterImpl.cfService == null) {
            Tr.error((TraceComponent)tc, (String)"NLSKEY_CFS_UNAVAILABLE");
            throw new IllegalStateException("The ChannelFrameworkService is not available for determining the best end point.");
        }
        cFEndPoint = ChannelSelectionAdapterImpl.cfService.determineBestEndPoint(this.cfEndpoints, this.criteria);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCFEndPoint", (Object)cFEndPoint);
        }
        return cFEndPoint;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void startMonitorEndPoints() {
        block11: {
            EndPoint[] endPointArray;
            CFEndPoint[] cFEndPointArray;
            block9: {
                int n;
                block10: {
                    block7: {
                        block8: {
                            if (tc.isEntryEnabled()) {
                                Tr.entry((TraceComponent)tc, (String)"startMonitorEndPoints");
                            }
                            if (ChannelSelectionAdapterImpl.hmService == null) break block7;
                            if (ChannelSelectionAdapterImpl.cfService == null) {
                                Tr.error((TraceComponent)tc, (String)"NLSKEY_CFS_UNAVAILABLE");
                                throw new IllegalStateException("The ChannelFrameworkService is not available for obtaining all selected end points..");
                            }
                            if (this.cfEndpoints == null) {
                                this.getCFEndPoint();
                            }
                            if (this.cfEndpoints == null) break block8;
                            cFEndPointArray = ChannelSelectionAdapterImpl.cfService.getEndPoints(this.cfEndpoints, this.criteria);
                            if (cFEndPointArray.length >= (endPointArray = this.wlmEndPoints).length) break block9;
                            endPointArray = new EndPoint[cFEndPointArray.length];
                            n = 0;
                            break block10;
                        }
                        Tr.event((TraceComponent)tc, (String)"Unable to retrieve end points to monitor for this ChannelTarget.");
                        break block11;
                    }
                    if (!this.postedNoHealthMonitorWarning) {
                        this.postedNoHealthMonitorWarning = true;
                        Tr.event((TraceComponent)tc, (String)"HealthMonitorManager is not available.");
                    }
                    break block11;
                }
                for (int i = 0; i < cFEndPointArray.length; ++i) {
                    while (cFEndPointArray[i] != this.cfEndpoints[n]) {
                        ++n;
                    }
                    endPointArray[i] = this.wlmEndPoints[n];
                }
            }
            ChannelSelectionAdapterImpl.hmService.addMonitoringEndPoints(cFEndPointArray, endPointArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startMonitorEndPoints");
        }
    }

    public boolean isMemberInProcess() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInProcess();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)(ChannelTargetImpl.class.getName() + ".isMemberInProcess"), (String)"193", (Object)this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"unexpected", (Object)classCastException);
            }
        }
        return bl;
    }

    public boolean isMemberInHost() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInHost();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)(ChannelTargetImpl.class.getName() + ".isMemberInHost"), (String)"215", (Object)this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"unexpected", (Object)classCastException);
            }
        }
        return bl;
    }

    public boolean isMemberInServer() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInServer();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, (String)(ChannelTargetImpl.class.getName() + ".isMemberInServer"), (String)"236", (Object)this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"unexpected", (Object)classCastException);
            }
        }
        return bl;
    }

    static {
        distinction.put("TYPE", "CHANNEL");
        distinction.put("COMPONENT", "CF");
    }
}

