/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.EnvUtil;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.PropsLoader;
import com.ibm.ws.process.StopParams;
import com.ibm.ws.process.exception.ProcessOpException;
import java.util.Properties;

public class ProcessFactory {
    private static String osName = System.getProperty("os.name");
    private static Properties props = null;
    private static ProcessObjectFactory procClass;
    private static EnvUtil envUtilClass;

    public static Process create(CreationParams creationParams) throws ProcessOpException {
        Process process;
        ProcessObjectFactory processObjectFactory = ProcessFactory.getProcessObjectFactory();
        try {
            process = processObjectFactory.create(creationParams);
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, (String)"com.ibm.ws.process.ProcessFactory.create", (String)"58");
            throw processOpException;
        }
        return process;
    }

    public static Process recreate(String string) throws ProcessOpException {
        return ProcessFactory.bindTo(string);
    }

    public static Process bindTo(String string) throws ProcessOpException {
        Process process;
        ProcessObjectFactory processObjectFactory = ProcessFactory.getProcessObjectFactory();
        try {
            process = processObjectFactory.bindTo(string);
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, (String)"com.ibm.ws.process.ProcessFactory.bindTo", (String)"93");
            throw processOpException;
        }
        return process;
    }

    public static Process createSelf() throws ProcessOpException {
        Process process;
        ProcessObjectFactory processObjectFactory = ProcessFactory.getProcessObjectFactory();
        try {
            process = processObjectFactory.createSelf();
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, (String)"com.ibm.ws.process.ProcessFactory.createSelf", (String)"104");
            throw processOpException;
        }
        return process;
    }

    public static synchronized void terminate(StopParams stopParams) throws ProcessOpException {
        ProcessObjectFactory processObjectFactory = ProcessFactory.getProcessObjectFactory();
        try {
            processObjectFactory.terminate(stopParams);
        }
        catch (ProcessOpException processOpException) {
            FFDCFilter.processException((Throwable)processOpException, (String)"com.ibm.ws.process.ProcessFactory.terminate", (String)"142");
            throw processOpException;
        }
    }

    public static EnvUtil getEnvUtil() throws ClassNotFoundException {
        return ProcessFactory.getEnvUtilImpl();
    }

    private static String getProcessImplClassName() throws ProcessOpException {
        try {
            ProcessFactory.loadProperties();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.process.ProcessFactory.getProcessImplClassName", (String)"123");
            throw new ProcessOpException(exception.toString());
        }
        if (osName.startsWith("Windows")) {
            return props.getProperty("wintel");
        }
        if (osName.startsWith("NetWare")) {
            return props.getProperty("netware");
        }
        if (osName.startsWith("Linux")) {
            return props.getProperty("linux");
        }
        if (osName.startsWith("z/OS") || osName.startsWith("OS/390")) {
            return props.getProperty("zOS");
        }
        return props.getProperty("unix");
    }

    private static String getProcessImplClassName(String string) throws ProcessOpException {
        try {
            ProcessFactory.loadProperties();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.process.ProcessFactory.getProcessImplClassName", (String)"123");
            throw new ProcessOpException(exception.toString());
        }
        String string2 = props.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (osName.startsWith("Windows")) {
            return props.getProperty("wintel");
        }
        if (osName.startsWith("NetWare")) {
            return props.getProperty("netware");
        }
        if (osName.startsWith("Linux")) {
            return props.getProperty("linux");
        }
        if (osName.startsWith("z/OS") || osName.startsWith("OS/390")) {
            return props.getProperty("zOS");
        }
        return props.getProperty("unix");
    }

    private static String getEnvUtilImplClassName() throws ProcessOpException {
        try {
            ProcessFactory.loadProperties();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.process.ProcessFactory.getProcessImplClassName", (String)"123");
            throw new ProcessOpException(exception.toString());
        }
        return props.getProperty("genericEnvUtil");
    }

    private static void loadProperties() throws Exception {
        if (props == null) {
            PropsLoader propsLoader = new PropsLoader();
            props = propsLoader.loadProperties();
        }
    }

    private static synchronized ProcessObjectFactory getProcessObjectFactory() throws ProcessOpException {
        if (procClass == null) {
            try {
                procClass = (ProcessObjectFactory)Class.forName(ProcessFactory.getProcessImplClassName()).newInstance();
                if (procClass.isPOSIXThreading() && osName.startsWith("Linux")) {
                    procClass = (ProcessObjectFactory)Class.forName(ProcessFactory.getProcessImplClassName("unix")).newInstance();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.process.ProcessFactory.getProcessObjectFactory", (String)"172");
                throw new ProcessOpException(exception.toString());
            }
        }
        return procClass;
    }

    private static synchronized EnvUtil getEnvUtilImpl() throws ClassNotFoundException {
        if (envUtilClass == null) {
            try {
                envUtilClass = (EnvUtil)Class.forName(ProcessFactory.getEnvUtilImplClassName()).newInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.process.ProcessFactory.getEnvUtilObject", (String)"172");
                throw new ClassNotFoundException(exception.toString());
            }
        }
        return envUtilClass;
    }
}

