/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util.config;

import [Ljava.lang.String;;
import com.ibm.ws.util.config.ConfigParams;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;

public class ConfigInstance {
    static final String create = "-create";
    static final String delete = "-delete";
    static final String host = "-host";
    static final String startPort = "-startingPort";
    static final String name = "-name";
    static final String path = "-path";
    static final String mqPath = "-mqpath";
    static final String embdpath = "-embeddedPath";
    static final String remote = "-remote";
    static String buildFile = "instance.xml";
    static String[] newArgs = new String[]{"-buildfile", "instance.xml", "create", "-quiet"};

    public static void main(String[] stringArray) {
        ConfigParams configParams;
        if (stringArray.length < 2) {
            ConfigInstance.usage();
        }
        if ((configParams = ConfigInstance.processArgs(stringArray)) != null) {
            if (configParams.action == null || configParams.hostName == null) {
                ConfigInstance.usage();
                return;
            }
            ConfigInstance.runAnt(configParams);
        }
    }

    static ConfigParams processArgs(String[] stringArray) {
        try {
            ConfigParams configParams = new ConfigParams();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equalsIgnoreCase(create)) {
                    configParams.action = "create";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(delete)) {
                    configParams.action = "delete";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(host)) {
                    configParams.hostName = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(startPort)) {
                    configParams.startPort = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(name)) {
                    configParams.instanceName = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(path)) {
                    configParams.instancePath = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(embdpath)) {
                    configParams.embeddedLocation = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(mqPath)) {
                    configParams.mqLocation = stringArray[i + 1];
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase(remote)) {
                    configParams.remote = "true";
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("-buildfile")) {
                    buildFile = stringArray[i + 1];
                    ConfigInstance.newArgs[1] = stringArray[i + 1];
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("-debug")) continue;
                ConfigInstance.newArgs[3] = "-debug";
            }
            return configParams;
        }
        catch (Throwable throwable) {
            ConfigInstance.usage();
            System.exit(0);
            return null;
        }
    }

    static void runAnt(ConfigParams configParams) {
        try {
            Object object;
            Serializable serializable;
            String string = System.getProperty("was.root");
            if (string != null) {
                serializable = new File(string);
                object = ((File)serializable).getCanonicalPath();
                System.setProperty("was.root", (String)object);
                System.setProperty("was.root.forwardslashes", ((String)object).replace('\\', '/'));
            }
            System.setProperty("new.host.name", configParams.hostName);
            System.setProperty("instance.name", configParams.instanceName);
            System.setProperty("new.instance.root", configParams.instancePath);
            if (configParams.startPort != null) {
                System.setProperty("start.port", configParams.startPort);
            }
            if (configParams.embeddedLocation != null) {
                System.setProperty("embed.location", configParams.embeddedLocation);
            }
            if (configParams.mqLocation != null) {
                System.setProperty("mq.location", configParams.mqLocation);
            }
            if (configParams.remote != null) {
                System.setProperty("remote", configParams.remote);
            }
            ConfigInstance.newArgs[2] = configParams.action;
            serializable = Class.forName("org.apache.tools.ant.Main");
            object = ((Class)serializable).getMethod("main", String;.class);
            Object object2 = ((Method)object).invoke(null, new Object[]{newArgs});
        }
        catch (Throwable throwable) {
            ConfigInstance.usage();
            System.exit(0);
        }
    }

    static void usage() {
        System.out.println("Usage:");
        System.out.println("wsinstance.bat(sh) -name instanceName -path instancePath -host hostName [-remote] [-startingPort startingPort] -create|-delete  [-debug]");
    }
}

