/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.util.BoundedBuffer;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPoolListener;
import com.ibm.ws.util.ZThreadUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;

public class ThreadPool {
    private static TraceComponent tc = Tr.register((Class)ThreadPool.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    public static final int DEFAULT_MAXIMUMPOOLSIZE = 10;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 0;
    public static final long DEFAULT_KEEPALIVETIME = 5000L;
    public static final int WAIT_WHEN_QUEUE_IS_FULL = 0;
    public static final int ERROR_WHEN_QUEUE_IS_FULL = 1;
    public static final int EXPAND_WHEN_QUEUE_IS_FULL_ERROR_AT_LIMIT = 2;
    public static final int EXPAND_WHEN_QUEUE_IS_FULL_WAIT_AT_LIMIT = 3;
    protected int maximumPoolSize_ = 10;
    protected int minimumPoolSize_ = 0;
    protected int poolSize_ = 0;
    protected int activeThreads = 0;
    protected long keepAliveTime_ = 5000L;
    protected BoundedBuffer requestBuffer;
    protected boolean shutdown_ = false;
    protected final Map threads_;
    protected int threadid = 0;
    protected boolean growasneeded = false;
    private boolean clearJavaLangThreadLocals = false;
    protected int threadpriority = 5;
    private static ThreadPoolListener[] ZERO_TP_LISTENERS = new ThreadPoolListener[0];
    protected ThreadPoolListener[] threadPoolListeners;
    protected String name;
    private MonitorPlugin monitorPlugin = null;
    private int requestBufferExpansionLimit_;
    private int requestBufferInitialCapacity_;
    private boolean lastThreadCheckDidntComplete = false;
    private boolean isZOS = false;
    protected boolean _isDecoratedZOS = false;
    protected static Class xMemCRBridgeClass = null;
    protected static Method xMemSetupThread = null;
    private int daemonId = -1;
    private static Field threadLocalsField;
    static Object[] ZERO_OBJECTS;

    public ThreadPool(int n, int n2, ThreadPoolListener[] threadPoolListenerArray) {
        this(null, n, n2, threadPoolListenerArray);
    }

    public ThreadPool(String string, int n, int n2) {
        this(string, n, n2, null);
    }

    public ThreadPool(String string, int n, int n2, ThreadPoolListener[] threadPoolListenerArray) {
        PlatformHelper platformHelper = null;
        this.name = string;
        this.maximumPoolSize_ = n2;
        this.minimumPoolSize_ = n;
        this.requestBufferExpansionLimit_ = n2 * 10;
        this.threads_ = new HashMap();
        String string2 = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return System.getProperty("com.ibm.websphere.threadpool.clearThreadLocal");
            }
        });
        if (string2 != null && Boolean.valueOf(string2).equals(Boolean.TRUE)) {
            this.setClearThreadLocals(true);
        }
        this.requestBufferInitialCapacity_ = (n + n2) / 2;
        if (this.requestBufferInitialCapacity_ <= 0) {
            this.requestBufferInitialCapacity_ = 1;
        }
        this.requestBuffer = new BoundedBuffer(this.requestBufferInitialCapacity_);
        this.threadPoolListeners = threadPoolListenerArray == null ? ZERO_TP_LISTENERS : (ThreadPoolListener[])threadPoolListenerArray.clone();
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadPoolCreated(this);
        }
        platformHelper = PlatformHelperFactory.getPlatformHelper();
        this.isZOS = platformHelper.isZOS();
    }

    public String getName() {
        return this.name;
    }

    public void setClearThreadLocals(boolean bl) {
        this.clearJavaLangThreadLocals = bl;
        if (bl) {
            Tr.warning((TraceComponent)tc, (String)"WSVR0623W", (Object)this.name);
        }
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = n;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = n;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long l) {
        this.keepAliveTime_ = l;
    }

    public synchronized void setRequestBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("request buffer size must be greater than zero");
        }
        if (this.requestBuffer.size() != 0) {
            throw new IllegalStateException("cannot resize non-empty ThreadPool request buffer");
        }
        this.requestBuffer = new BoundedBuffer(n);
        this.requestBufferInitialCapacity_ = n;
    }

    public synchronized int getRequestBufferSize() {
        return this.requestBuffer.capacity();
    }

    protected void addThread(Runnable runnable) {
        Worker worker = this._isDecoratedZOS ? new DecoratedZOSWorker(runnable, this.threadid++) : new Worker(runnable, this.threadid++);
        this.threads_.put(worker, worker);
        ++this.poolSize_;
        ++this.activeThreads;
        this.fireThreadCreated(this.poolSize_);
        worker.start();
    }

    public void addZOSThread(int n, int n2, long l, ZThreadUtilities zThreadUtilities) throws UnsupportedOperationException {
        ZOSWorker zOSWorker = new ZOSWorker(n, n2, l, zThreadUtilities);
        this.threads_.put(zOSWorker, zOSWorker);
        ++this.poolSize_;
        this.fireThreadCreated(this.poolSize_);
        zOSWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (this.poolSize_ < this.maximumPoolSize_) {
                    this.addThread(null);
                    ++n2;
                } else {
                    break;
                }
                continue;
            }
        }
        return n2;
    }

    public synchronized void shutdownNow() {
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized void interruptAll() {
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            thread.interrupt();
        }
    }

    public synchronized boolean awaitTerminationAfterShutdown(long l) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long l2 = l;
        if (l2 <= 0L) {
            return false;
        }
        long l3 = System.currentTimeMillis();
        do {
            this.wait(l2);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((l2 = l - (System.currentTimeMillis() - l3)) > 0L);
        return false;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    protected synchronized void workerDone(Worker worker, boolean bl) {
        this.threads_.remove(worker);
        if (bl) {
            --this.activeThreads;
            --this.poolSize_;
        }
        if (this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        this.fireThreadDestroyed(this.poolSize_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable getTask() throws InterruptedException {
        Runnable runnable = null;
        boolean bl = true;
        while (true) {
            long l;
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                if (bl) {
                    --this.activeThreads;
                }
                if (!(this.poolSize_ <= this.maximumPoolSize_ || this.growasneeded && bl)) {
                    --this.poolSize_;
                    return null;
                }
                l = this.shutdown_ ? 0L : (this.poolSize_ <= this.minimumPoolSize_ ? -1L : this.keepAliveTime_);
            }
            try {
                runnable = l >= 0L ? (Runnable)this.requestBuffer.poll(l) : (Runnable)this.requestBuffer.take();
            }
            catch (InterruptedException interruptedException) {
                ++this.activeThreads;
                throw new InterruptedException();
            }
            threadPool = this;
            synchronized (threadPool) {
                if (runnable == null) {
                    runnable = (Runnable)this.requestBuffer.poll(0L);
                }
                if (runnable != null) {
                    ++this.activeThreads;
                    break;
                }
                if (this.poolSize_ > this.minimumPoolSize_) {
                    --this.poolSize_;
                    break;
                }
            }
            bl = false;
        }
        return runnable;
    }

    public void setGrowAsNeeded(boolean bl) {
        this.growasneeded = bl;
    }

    public boolean isGrowAsNeeded() {
        return this.growasneeded;
    }

    public void setThreadPriority(int n) {
        this.threadpriority = n;
    }

    public int getThreadPriority() {
        return this.threadpriority;
    }

    public void setDecoratedZOS() {
        if (xMemSetupThread == null) {
            try {
                xMemCRBridgeClass = Class.forName("com.ibm.xmem.ws390.XMemCRBridge");
                xMemSetupThread = xMemCRBridgeClass.getMethod("setupThreadStub", Object.class);
            }
            catch (Exception exception) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Unexpected Exception caught acccessing XMemCRBridge.setupThreadStub()", (Object)exception);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.util.ThreadPool.setDecoratedZOS", (String)"874");
            }
        }
        if (xMemSetupThread != null) {
            this._isDecoratedZOS = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOnDaemon(Runnable runnable) {
        int n = 0;
        final Runnable runnable2 = runnable;
        Object object = this;
        synchronized (object) {
            ++this.daemonId;
            n = this.daemonId;
        }
        object = this.name + " : DMN" + n;
        Thread thread = (Thread)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((String)object){
            private final /* synthetic */ String val$runId;
            {
                this.val$runId = string;
            }

            public Object run() {
                Thread thread = new Thread(runnable2, this.val$runId);
                thread.setDaemon(true);
                return thread;
            }
        });
        thread.start();
    }

    public void execute(Runnable runnable) throws InterruptedException {
        try {
            this.execute(runnable, 0, 0L);
        }
        catch (ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException((Throwable)((Object)threadPoolQueueIsFullException), (String)ThreadPool.class.getName(), (String)"564");
        }
    }

    public void execute(Runnable runnable, int n) throws InterruptedException, ThreadPoolQueueIsFullException {
        this.execute(runnable, n, 0L);
    }

    public Runnable execute(Runnable runnable, long l) throws InterruptedException {
        try {
            return this.execute(runnable, 0, l);
        }
        catch (ThreadPoolQueueIsFullException threadPoolQueueIsFullException) {
            FFDCFilter.processException((Throwable)((Object)threadPoolQueueIsFullException), (String)ThreadPool.class.getName(), (String)"855");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable execute(Runnable runnable, int n, long l) throws InterruptedException, ThreadPoolQueueIsFullException {
        int n2;
        int n3;
        block15: {
            boolean bl = false;
            boolean bl2 = false;
            while (true) {
                if (bl2) {
                    Thread.yield();
                }
                if (!bl && (bl = this.requestBuffer.offer(runnable, 0L)) && this.minimumPoolSize_ == this.maximumPoolSize_ && this.poolSize_ == this.minimumPoolSize_ && !this.growasneeded) {
                    return runnable;
                }
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    if (!this.shutdown_) {
                        if (this.growasneeded && !bl && !bl2) {
                            bl2 = true;
                            continue;
                        }
                        n3 = this.poolSize_;
                        if (bl && (this.requestBuffer.size() == 0 || n3 - this.activeThreads >= this.requestBuffer.size())) {
                            return runnable;
                        }
                        if (n3 < this.maximumPoolSize_ || this.growasneeded) {
                            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                                public Object run() {
                                    ThreadPool.this.addThread(null);
                                    return null;
                                }
                            });
                        }
                        if (bl) {
                            return runnable;
                        }
                    }
                }
                if (n == 0) {
                    if (l > 0L) {
                        return (Runnable)this.requestBuffer.put(runnable, l, this.requestBufferInitialCapacity_);
                    }
                    this.requestBuffer.put(runnable);
                    bl = true;
                    continue;
                }
                if (n == 1) {
                    throw new ThreadPoolQueueIsFullException();
                }
                n2 = this.requestBuffer.capacity();
                if (n2 != this.requestBufferExpansionLimit_) break block15;
                if (n != 3) break;
                if (l > 0L) {
                    return (Runnable)this.requestBuffer.put(runnable, l);
                }
                this.requestBuffer.put(runnable);
                bl = true;
            }
            throw new ThreadPoolQueueIsFullException();
        }
        n3 = Math.min(n2 / 2, this.requestBufferExpansionLimit_ - n2);
        Tr.uncondEvent((TraceComponent)tc, (String)("Exanding buffer of ThreadPool " + this.name + " by " + n3));
        this.requestBuffer.expand(n3);
        return this.execute(runnable, n, l);
    }

    public void addThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n = this.threadPoolListeners.length + 1;
        ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n];
        System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n - 1);
        threadPoolListenerArray[n - 1] = threadPoolListener;
        this.threadPoolListeners = threadPoolListenerArray;
    }

    public void removeThreadPoolListener(ThreadPoolListener threadPoolListener) {
        int n;
        for (n = 0; n < this.threadPoolListeners.length && this.threadPoolListeners[n] != threadPoolListener; ++n) {
        }
        if (n < this.threadPoolListeners.length) {
            int n2 = this.threadPoolListeners.length - 1;
            ThreadPoolListener[] threadPoolListenerArray = new ThreadPoolListener[n2];
            System.arraycopy(this.threadPoolListeners, 0, threadPoolListenerArray, 0, n);
            System.arraycopy(this.threadPoolListeners, n + 1, threadPoolListenerArray, n, n2 - n - 1);
            this.threadPoolListeners = threadPoolListenerArray;
        }
    }

    protected void fireThreadCreated(int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadCreated(this, n);
        }
    }

    protected void fireThreadStarted(int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadStarted(this, n, n2);
        }
    }

    protected void fireThreadReturned(int n, int n2) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadReturned(this, n, n2);
        }
    }

    protected void fireThreadDestroyed(int n) {
        for (int i = 0; i < this.threadPoolListeners.length; ++i) {
            this.threadPoolListeners[i].threadDestroyed(this, n);
        }
    }

    public synchronized boolean areRequestsOutstanding() {
        if (this.poolSize_ == 0) {
            return false;
        }
        Iterator iterator = this.threads_.values().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            if (!thread.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void setMonitorPlugin(MonitorPlugin monitorPlugin) throws TooManyListenersException {
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMonitorPlugin", (Object)monitorPlugin);
        }
        if (this.monitorPlugin != null && !this.monitorPlugin.equals(monitorPlugin)) {
            throw new TooManyListenersException("INTERNAL ERROR: ThreadPool.MonitorPlugin already set.");
        }
        this.monitorPlugin = monitorPlugin;
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMonitorPlugin", (Object)monitorPlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllThreads() {
        if (this.monitorPlugin == null) {
            return;
        }
        long l = 0L;
        try {
            Iterator iterator = this.threads_.values().iterator();
            while (iterator.hasNext()) {
                Worker worker;
                Worker worker2 = worker = (Worker)iterator.next();
                synchronized (worker2) {
                    if (worker.getStartTime() > 0L && !worker.hangDetectionDisabled) {
                        if (l == 0L) {
                            l = System.currentTimeMillis();
                        }
                        if (this.monitorPlugin.checkThread(worker.getName(), worker.threadNumber, l - worker.getStartTime())) {
                            worker.isHung = true;
                        }
                    }
                }
            }
            this.lastThreadCheckDidntComplete = false;
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            if (this.lastThreadCheckDidntComplete) {
                FFDCFilter.processException((Throwable)concurrentModificationException, (String)this.getClass().getName(), (String)"1181", (Object)this);
            }
            this.lastThreadCheckDidntComplete = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetThreadHangState(Thread thread) {
        if (thread instanceof Worker) {
            Thread thread2 = thread;
            synchronized (thread2) {
                ((Worker)thread).setStartTime(0L);
            }
        } else {
            throw new IllegalArgumentException("Thread " + thread.getName() + " is not a managed thread.");
        }
    }

    public void setRequestBufferExpansionLimit(int n) {
        this.requestBufferExpansionLimit_ = n;
    }

    private synchronized void incActive() {
        ++this.activeThreads;
    }

    private synchronized void decActive() {
        --this.activeThreads;
    }

    private synchronized void decPoolSize() {
        --this.poolSize_;
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.util.ThreadPool", (String)"485");
        }
        ZERO_OBJECTS = new Object[0];
    }

    class DecoratedZOSWorker
    extends Worker
    implements DecoratedCRThread {
        protected DecoratedZOSWorker(Runnable runnable, int n) {
            super(runnable, n);
        }

        public void run() {
            this.threadNumber = RasHelper.getThreadId();
            try {
                xMemSetupThread.invoke(null, this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.util.ThreadPool.DecoratedZOSWorker.run()", (String)"1737", (Object)this);
            }
        }

        public void processTasks() {
            super.run();
        }
    }

    private static class WasThreadLocalData {
        Object key = null;
        Object value = null;

        private WasThreadLocalData() {
        }
    }

    class ZOSWorker
    extends Worker
    implements WorkerZOSThread {
        private int internalWorkThread;
        private int useWLM;
        private ZThreadUtilities utils;

        public ZOSWorker(int n, int n2, long l, ZThreadUtilities zThreadUtilities) {
            super((ThreadGroup)null, (Runnable)null, "WebSphere:" + ThreadPool.this.name + " t=", l);
            this.internalWorkThread = 0;
            this.useWLM = 0;
            this.utils = null;
            if (!ThreadPool.this.isZOS) {
                throw new UnsupportedOperationException("Method not supported on this platform");
            }
            this.internalWorkThread = n;
            this.useWLM = n2;
            this.utils = zThreadUtilities;
            this.setPriority(ThreadPool.this.getThreadPriority());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.threadNumber = RasHelper.getThreadId();
            try {
                try {
                    this.utils.runApplicationThread(this.internalWorkThread, this.useWLM);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)this.getClass().getName(), (String)"1567", (Object)this);
                    Tr.uncondEvent((TraceComponent)tc, (String)("An error occured on a thread in Threadpool: " + ThreadPool.this.name), (Object)throwable);
                    Object var3_2 = null;
                    ThreadPool.this.decPoolSize();
                    ThreadPool.this.workerDone(this, false);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                ThreadPool.this.decPoolSize();
                ThreadPool.this.workerDone(this, false);
                throw throwable;
            }
            ThreadPool.this.decPoolSize();
            ThreadPool.this.workerDone(this, false);
        }

        public synchronized void threadStarted() {
            ThreadPool.this.incActive();
            ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
            if (ThreadPool.this.monitorPlugin != null) {
                this.setStartTime(System.currentTimeMillis());
                this.isHung = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void threadReturned() {
            if (ThreadPool.this.monitorPlugin != null) {
                ZOSWorker zOSWorker = this;
                synchronized (zOSWorker) {
                    if (this.isHung) {
                        ThreadPool.this.monitorPlugin.clearThread(this.getName(), this.threadNumber, System.currentTimeMillis() - this.getStartTime());
                    }
                    this.setStartTime(0L);
                    this.hangDetectionDisabled = false;
                    this.isHung = false;
                }
            }
            ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
            if (this.numberOfActiveWasThreadLocals > 0) {
                for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                    this.activeWasThreadLocals[i].key = null;
                    this.activeWasThreadLocals[i].value = null;
                }
                this.numberOfActiveWasThreadLocals = 0;
            }
            if (ThreadPool.this.clearJavaLangThreadLocals) {
                try {
                    threadLocalsField.set(this, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ThreadPool.this.decActive();
        }
    }

    class Worker
    extends Thread
    implements WorkerThread,
    WasThreadLocalSupport {
        protected Runnable firstTask_;
        private String id;
        Object[] wsThreadLocals;
        private volatile long startTime;
        protected volatile boolean isHung;
        protected String threadNumber;
        protected volatile boolean hangDetectionDisabled;
        WasThreadLocalData[] activeWasThreadLocals;
        int numberOfActiveWasThreadLocals;

        protected synchronized long getStartTime() {
            return this.startTime;
        }

        protected synchronized void setStartTime(long l) {
            this.startTime = l;
        }

        protected Worker(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
            super(threadGroup, runnable, string, l);
            this.id = null;
            this.wsThreadLocals = ZERO_OBJECTS;
            this.startTime = 0L;
            this.isHung = false;
            this.threadNumber = "-1";
            this.hangDetectionDisabled = false;
            this.activeWasThreadLocals = new WasThreadLocalData[0];
            this.numberOfActiveWasThreadLocals = 0;
        }

        protected Worker(Runnable runnable, int n) {
            super(ThreadPool.this.name + " : " + n);
            this.id = null;
            this.wsThreadLocals = ZERO_OBJECTS;
            this.startTime = 0L;
            this.isHung = false;
            this.threadNumber = "-1";
            this.hangDetectionDisabled = false;
            this.activeWasThreadLocals = new WasThreadLocalData[0];
            this.numberOfActiveWasThreadLocals = 0;
            this.firstTask_ = runnable;
            this.setPriority(ThreadPool.this.getThreadPriority());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.threadNumber = RasHelper.getThreadId();
            Runnable runnable = this.firstTask_;
            try {
                this.firstTask_ = null;
                do {
                    Object object2222;
                    Object var3_2;
                    if (runnable == null) continue;
                    ThreadPool.this.fireThreadStarted(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    if (ThreadPool.this.monitorPlugin != null) {
                        this.setStartTime(System.currentTimeMillis());
                        this.isHung = false;
                    }
                    try {
                        runnable.run();
                        var3_2 = null;
                    }
                    catch (Throwable throwable) {
                        var3_2 = null;
                        if (ThreadPool.this.monitorPlugin != null) {
                            object2222 = this;
                            synchronized (object2222) {
                                if (this.isHung) {
                                    ThreadPool.this.monitorPlugin.clearThread(this.getName(), this.threadNumber, System.currentTimeMillis() - this.getStartTime());
                                }
                                this.setStartTime(0L);
                                this.hangDetectionDisabled = false;
                                this.isHung = false;
                            }
                        }
                        ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                        if (this.numberOfActiveWasThreadLocals > 0) {
                            for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                                this.activeWasThreadLocals[i].key = null;
                                this.activeWasThreadLocals[i].value = null;
                            }
                            this.numberOfActiveWasThreadLocals = 0;
                        }
                        if (!ThreadPool.this.clearJavaLangThreadLocals) throw throwable;
                        try {
                            threadLocalsField.set(this, null);
                            throw throwable;
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    if (ThreadPool.this.monitorPlugin != null) {
                        object2222 = this;
                        synchronized (object2222) {
                            if (this.isHung) {
                                ThreadPool.this.monitorPlugin.clearThread(this.getName(), this.threadNumber, System.currentTimeMillis() - this.getStartTime());
                            }
                            this.setStartTime(0L);
                            this.hangDetectionDisabled = false;
                            this.isHung = false;
                        }
                    }
                    ThreadPool.this.fireThreadReturned(ThreadPool.this.activeThreads, ThreadPool.this.maximumPoolSize_);
                    if (this.numberOfActiveWasThreadLocals > 0) {
                        for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                            this.activeWasThreadLocals[i].key = null;
                            this.activeWasThreadLocals[i].value = null;
                        }
                        this.numberOfActiveWasThreadLocals = 0;
                    }
                    if (!ThreadPool.this.clearJavaLangThreadLocals) continue;
                    try {}
                    catch (IllegalAccessException object2222) {}
                    threadLocalsField.set(this, null);
                } while ((runnable = ThreadPool.this.getTask()) != null);
                ThreadPool.this.workerDone(this, runnable != null);
                return;
            }
            catch (InterruptedException interruptedException) {
                try {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"InterruptedException Caught", (Object)new Object[]{new Integer(ThreadPool.this.activeThreads)});
                    }
                    ThreadPool.this.workerDone(this, runnable != null);
                    return;
                }
                catch (Throwable throwable) {
                    ThreadPool.this.workerDone(this, runnable != null);
                    throw throwable;
                }
            }
        }

        public void disableHangDetectionForCurrentDispatch() {
            this.hangDetectionDisabled = true;
        }

        public void iAmAlive() {
            this.setStartTime(System.currentTimeMillis());
        }

        public Object get(Object object) {
            if (object == null) {
                return null;
            }
            for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                if (!object.equals(this.activeWasThreadLocals[i].key)) continue;
                return this.activeWasThreadLocals[i].value;
            }
            return null;
        }

        public void set(Object object, Object object2) {
            if (object == null) {
                return;
            }
            for (int i = 0; i < this.numberOfActiveWasThreadLocals; ++i) {
                if (!object.equals(this.activeWasThreadLocals[i].key)) continue;
                this.activeWasThreadLocals[i].value = object2;
                return;
            }
            if (this.numberOfActiveWasThreadLocals == this.activeWasThreadLocals.length) {
                WasThreadLocalData[] wasThreadLocalDataArray = new WasThreadLocalData[this.numberOfActiveWasThreadLocals + 1];
                System.arraycopy(this.activeWasThreadLocals, 0, wasThreadLocalDataArray, 0, this.numberOfActiveWasThreadLocals);
                wasThreadLocalDataArray[this.numberOfActiveWasThreadLocals] = new WasThreadLocalData();
                this.activeWasThreadLocals = wasThreadLocalDataArray;
            }
            this.activeWasThreadLocals[this.numberOfActiveWasThreadLocals].key = object;
            this.activeWasThreadLocals[this.numberOfActiveWasThreadLocals].value = object2;
            ++this.numberOfActiveWasThreadLocals;
        }
    }

    public static class ThreadPoolQueueIsFullException
    extends WsException {
        private static final long serialVersionUID = 5986384706904725945L;

        public ThreadPoolQueueIsFullException() {
        }

        public ThreadPoolQueueIsFullException(String string) {
            super(string);
        }

        public ThreadPoolQueueIsFullException(Throwable throwable) {
            super(throwable);
        }

        public ThreadPoolQueueIsFullException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static interface WasThreadLocalSupport {
        public Object get(Object var1);

        public void set(Object var1, Object var2);
    }

    public static interface WorkerZOSThread {
        public void threadStarted();

        public void threadReturned();
    }

    public static interface WorkerThread {
        public void disableHangDetectionForCurrentDispatch();

        public void iAmAlive();
    }

    public static interface DecoratedCRThread
    extends WorkerThread {
        public void processTasks();
    }

    public static interface MonitorPlugin {
        public boolean checkThread(String var1, String var2, long var3);

        public void clearThread(String var1, String var2, long var3);
    }
}

