/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ImplFactory {
    private static TraceComponent tc = Tr.register((Class)ImplFactory.class, (String)"Runtime", (String)"com.ibm.ws.runtime.runtime");
    private static final String IF_PLUGIN_PATH = "META-INF/impl-factory.xml";
    private static Properties _props;

    public static Object loadImplFromKey(String string) {
        Class clazz = ImplFactory.loadClassFromKey(string);
        return ImplFactory.loadImplFromClass(clazz);
    }

    public static Object loadImplFromKey(Class clazz) {
        return ImplFactory.loadImplFromKey(clazz.getName());
    }

    public static Object loadImplFromClass(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return ImplFactory.loadImplFromClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.util.ImplFactory.loadImplFromClass", (String)"198");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ClassNotFoundException caught loading class " + string), (Object)classNotFoundException);
            }
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
    }

    public static Object loadImplFromClass(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.util.ImplFactory.loadImplFromClass", (String)"213");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Exception caught creating new instance of " + clazz), (Object)throwable);
            }
            throw new IllegalStateException(clazz.getName() + " is not a valid class.");
        }
    }

    public static Class loadClassFromKey(Class clazz) {
        return ImplFactory.loadClassFromKey(clazz.getName());
    }

    public static Class loadClassFromKey(String string) {
        String string2 = _props.getProperty(string);
        if (string2 == null) {
            throw new NoClassDefFoundError("Invalid Implementation Key, " + string);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.util.ImplFactory.loadClassFromKey", (String)"240");
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("ClassNotFoundException caught loading class " + string2), (Object)classNotFoundException);
            }
            throw new IllegalStateException(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            FactoryList factoryList;
            int n;
            _props = new Properties();
            List list = (List)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException, ParserConfigurationException, SAXException {
                    Properties properties = new Properties();
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Enumeration<URL> enumeration = classLoader.getResources(ImplFactory.IF_PLUGIN_PATH);
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    sAXParserFactory.setNamespaceAware(true);
                    XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                    ImplFactoryParsingHandler implFactoryParsingHandler = new ImplFactoryParsingHandler();
                    xMLReader.setContentHandler(implFactoryParsingHandler);
                    xMLReader.setDTDHandler(implFactoryParsingHandler);
                    xMLReader.setEntityResolver(implFactoryParsingHandler);
                    xMLReader.setErrorHandler(implFactoryParsingHandler);
                    ArrayList<FactoryList> arrayList = new ArrayList<FactoryList>();
                    while (enumeration.hasMoreElements()) {
                        URL uRL = enumeration.nextElement();
                        try {
                            xMLReader.parse(uRL.toExternalForm());
                            FactoryList factoryList = new FactoryList();
                            factoryList.rank = implFactoryParsingHandler.rank;
                            factoryList.factories.addAll(implFactoryParsingHandler.getFactories());
                            arrayList.add(factoryList);
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.util.ImplFactory.run", (String)"107", (Object)this);
                            if (!tc.isEventEnabled()) continue;
                            Tr.event((TraceComponent)tc, (String)("Exception caught parsing " + uRL), (Object)exception);
                        }
                    }
                    return arrayList;
                }
            });
            Collections.sort(list, new RankComparator());
            int n2 = list.size();
            for (n = 0; n < n2; ++n) {
                factoryList = (FactoryList)list.get(n);
                int n3 = factoryList.factories.size();
                for (int i = 0; i < n3; ++i) {
                    Factory factory = (Factory)factoryList.factories.get(i);
                    if (!_props.containsKey(factory.interfaceName)) {
                        if (factory.isOverride) {
                            Tr.warning((TraceComponent)tc, (String)"WSVR0071W", (Object)new Object[]{factory.interfaceName, factory.implName});
                        }
                        _props.setProperty(factory.interfaceName, factory.implName);
                        continue;
                    }
                    if (factory.isOverride) {
                        _props.setProperty(factory.interfaceName, factory.implName);
                        continue;
                    }
                    Tr.warning((TraceComponent)tc, (String)"WSVR0072W", (Object)new Object[]{factory.interfaceName, factory.implName});
                }
            }
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                factoryList = (FactoryList)list.get(n);
                factoryList.factories.clear();
            }
            list.clear();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.util.ImplFactory.<clinit>", (String)"170");
            Tr.warning((TraceComponent)tc, (String)"WSVR0073W", (Object)IF_PLUGIN_PATH);
        }
    }

    private static class RankComparator
    implements Comparator {
        private RankComparator() {
        }

        public int compare(Object object, Object object2) {
            FactoryList factoryList = (FactoryList)object;
            FactoryList factoryList2 = (FactoryList)object2;
            return factoryList.rank - factoryList2.rank;
        }
    }

    private static class ImplFactoryParsingHandler
    extends DefaultHandler {
        Locator locator;
        int rank = 0;
        List factories = new ArrayList();
        Factory factory;
        StringBuffer value = new StringBuffer();

        public List getFactories() {
            return this.factories;
        }

        public void startDocument() throws SAXException {
            this.factories.clear();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.value.setLength(0);
            if (!string3.equals("factories")) {
                if (string3.equals("factory")) {
                    this.factory = new Factory();
                    this.factory.isOverride = false;
                    int n = attributes.getLength();
                    for (int i = 0; i < n; ++i) {
                        String string4 = attributes.getQName(i);
                        String string5 = attributes.getValue(i);
                        if (string4.equals("interface")) {
                            this.factory.interfaceName = string5;
                            continue;
                        }
                        if (string4.equals("impl")) {
                            this.factory.implName = string5;
                            continue;
                        }
                        if (string4.equals("override")) {
                            this.factory.isOverride = true;
                            continue;
                        }
                        throw new SAXParseException("Invalid attribute: " + string4, this.locator);
                    }
                } else if (!string3.equals("rank")) {
                    throw new SAXParseException("Invalid tag: " + string3, this.locator);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("rank")) {
                try {
                    this.rank = Integer.parseInt(this.value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXParseException("Problem converting rank to number: " + this.value.toString(), this.locator);
                }
            } else if (string3.equals("factory") && this.factory != null) {
                this.factories.add(this.factory);
            }
            this.value.setLength(0);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.factory = null;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.factory = null;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.factories.clear();
            this.factory = null;
            throw sAXParseException;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.value.append(cArray, n, n2);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private static class FactoryList {
        public int rank;
        public List factories = new ArrayList();

        private FactoryList() {
        }

        public String toString() {
            return "[ rank = " + this.rank + ',' + this.factories + ']';
        }
    }

    private static class Factory {
        public String interfaceName;
        public String implName;
        public boolean isOverride = false;

        private Factory() {
        }

        public String toString() {
            return '[' + this.interfaceName + '=' + this.implName + ',' + this.isOverride + ']';
        }
    }
}

