/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.util.ClauseTable;
import com.ibm.ws.util.URIMatcher;
import java.util.ArrayList;
import java.util.List;

public class ClauseNode {
    int hashCode = -1;
    Object target = null;
    ClauseTable children;
    int length = -1;
    private static final int star = URIMatcher.computeHash("*");
    String cl;

    public ClauseNode(String string, Object object) {
        this.hashCode = URIMatcher.computeHash(string) & Integer.MAX_VALUE;
        this.target = object;
        this.length = string.length();
        this.cl = string;
        this.children = new ClauseTable();
    }

    public ClauseNode(String string, Object object, boolean bl) {
        this.hashCode = URIMatcher.computeHash(string) & Integer.MAX_VALUE;
        this.target = object;
        this.length = string.length();
        this.cl = string;
        this.children = new ClauseTable(bl);
    }

    public boolean isStar() {
        return this.hashCode == star;
    }

    public ClauseNode add(ClauseNode clauseNode) throws Exception {
        ClauseNode clauseNode2 = null;
        clauseNode2 = (ClauseNode)this.children.get(clauseNode);
        if (clauseNode2 != null) {
            if (clauseNode.getTarget() != null) {
                if (clauseNode2.getTarget() != null) {
                    throw new Exception("Mapping clash for " + clauseNode.getTarget() + ": Target " + clauseNode2.getTarget() + " already exists at node " + this.cl);
                }
                clauseNode2.setTarget(clauseNode.getTarget());
            }
            return clauseNode2;
        }
        this.children.add(clauseNode);
        return (ClauseNode)this.children.get(clauseNode);
    }

    public synchronized void setTarget(Object object) {
        this.target = object;
    }

    public synchronized Object getTarget() {
        return this.target;
    }

    public ClauseNode traverse(String string) {
        return (ClauseNode)this.children.get(URIMatcher.computeHash(string) & Integer.MAX_VALUE);
    }

    public ClauseNode traverse(int n) {
        return (ClauseNode)this.children.get(n & Integer.MAX_VALUE);
    }

    public Object getTarget(String string) {
        if (URIMatcher.computeHash(string) == this.hashCode && string.length() == this.length) {
            return this.target;
        }
        return null;
    }

    public List targets() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = this.children.getList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ClauseNode clauseNode = (ClauseNode)arrayList2.get(i);
            arrayList.addAll(clauseNode.targets());
        }
        if (this.target != null) {
            arrayList.add(this.target);
        }
        return arrayList;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void print() {
        if (this.children == null) {
            System.out.println("{EMPTY}");
        } else {
            this.children.print();
        }
    }

    public boolean remove(String string) {
        int n = string.substring(1).indexOf(47);
        if (n == -1) {
            String string2 = string.substring(1);
            ClauseNode clauseNode = this.traverse(string2);
            if (clauseNode != null) {
                this.children.remove(clauseNode);
            }
        } else {
            boolean bl;
            String string3 = string.substring(1, n + 1);
            ClauseNode clauseNode = this.traverse(string3);
            if (clauseNode != null && (bl = clauseNode.remove(string.substring(n + 1)))) {
                this.children.remove(clauseNode);
            }
        }
        return this.children.size() == 0;
    }

    public String toString() {
        return "CL:" + this.cl + "T:" + this.target;
    }
}

