/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.CaptureSocket;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class CaptureServerSocket
extends ServerSocket {
    private boolean captureOutput = false;
    private int count = -1;
    private ObjectOutputStream capturedOs = null;

    public CaptureServerSocket(int n, int n2, InetAddress inetAddress, String string, boolean bl) throws IOException {
        super(n, n2, inetAddress);
        this.captureOutput = bl;
        this.capturedOs = new ObjectOutputStream(new FileOutputStream(string));
        System.out.println("writing captured socket data to " + string + " ...");
    }

    public synchronized Socket accept() throws IOException {
        CaptureSocket captureSocket = new CaptureSocket(this.capturedOs, ++this.count, this.captureOutput);
        super.implAccept(captureSocket);
        System.out.println("accepted connection " + this.count);
        try {
            captureSocket.capture();
        }
        catch (SocketException socketException) {
            FFDCFilter.processException((Throwable)socketException, (String)"com.ibm.ws.util.CaptureServerSocket.accept", (String)"45", (Object)this);
            socketException.printStackTrace();
            throw new IOException("unable to capture socket: " + socketException.getMessage());
        }
        return captureSocket;
    }

    public void close() throws IOException {
        super.close();
        this.capturedOs.close();
    }
}

