/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class CaptureOutputStream
extends FilterOutputStream {
    private ByteArrayOutputStream captureOs = new ByteArrayOutputStream();

    public CaptureOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        super.write(n);
        this.captureOs.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        super.write(byArray);
        this.captureOs.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.captureOs.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        super.flush();
        this.captureOs.flush();
    }

    public byte[] getCapturedOutput() {
        return this.captureOs.toByteArray();
    }
}

