/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public final class Base64 {
    private static final TraceComponent tc;
    private static final char[] TOKENS;
    private static final char PAD_TOKEN = '=';
    private static final int TOKEN_MIN = 0;
    private static final int TOKEN_MAX = 127;
    private static final byte INVALID_TOKEN_VALUE = -1;
    private static final byte[] TOKEN_VALUES;

    private Base64() {
    }

    public static String encode(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)byArray);
        }
        String string = Base64.encode(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode", (Object)string);
        }
        return string;
    }

    public static void encode(byte[] byArray, Writer writer) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)new Object[]{byArray, writer});
        }
        Base64.encode(byArray, 0, byArray.length, writer);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode");
        }
    }

    public static void encode(byte[] byArray, int n, int n2, Writer writer) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)new Object[]{byArray, new Integer(n), new Integer(n2), writer});
        }
        writer.write(Base64.encode(byArray, n, n2));
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode");
        }
    }

    public static void encode(byte[] byArray, OutputStream outputStream) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)new Object[]{byArray, outputStream});
        }
        Base64.encode(byArray, 0, byArray.length, outputStream);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode");
        }
    }

    public static void encode(byte[] byArray, int n, int n2, OutputStream outputStream) throws IOException {
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)new Object[]{byArray, new Integer(n), new Integer(n2), outputStream});
        }
        int n4 = ((n3 = n2 % 3) == 0 ? n2 : n2 + 3 - n3) / 3 * 4;
        int n5 = 0;
        byte by = 0;
        byte[] byArray2 = new byte[n4];
        int n6 = 0;
        for (int i = n; i < n2; ++i) {
            byte by2 = byArray[i];
            switch (n5) {
                case 0: {
                    byArray2[n6++] = (byte)TOKENS[(by2 & 0xFC) >> 2];
                    n5 = 1;
                    break;
                }
                case 1: {
                    byArray2[n6++] = (byte)TOKENS[(by & 3) << 4 | (by2 & 0xF0) >> 4];
                    n5 = 2;
                    break;
                }
                case 2: {
                    byArray2[n6++] = (byte)TOKENS[(by & 0xF) << 2 | (by2 & 0xC0) >> 6];
                    byArray2[n6++] = (byte)TOKENS[by2 & 0x3F];
                    n5 = 0;
                }
            }
            by = by2;
        }
        switch (n5) {
            case 1: {
                byArray2[n6++] = (byte)TOKENS[(by & 3) << 4];
                byArray2[n6++] = 61;
                byArray2[n6++] = 61;
                break;
            }
            case 2: {
                byArray2[n6++] = (byte)TOKENS[(by & 0xF) << 2];
                byArray2[n6++] = 61;
            }
        }
        outputStream.write(byArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode");
        }
    }

    public static String encode(byte[] byArray, int n, int n2) {
        int n3;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)new Object[]{byArray, new Integer(n), new Integer(n2)});
        }
        int n4 = ((n3 = n2 % 3) == 0 ? n2 : n2 + 3 - n3) / 3 * 4;
        StringBuffer stringBuffer = new StringBuffer(n4);
        int n5 = 0;
        int n6 = 0;
        for (int i = n; i < n2; ++i) {
            int n7 = byArray[i];
            switch (n5) {
                case 0: {
                    stringBuffer.append(TOKENS[(n7 & 0xFC) >> 2]);
                    n5 = 1;
                    break;
                }
                case 1: {
                    stringBuffer.append(TOKENS[(n6 & 3) << 4 | (n7 & 0xF0) >> 4]);
                    n5 = 2;
                    break;
                }
                case 2: {
                    stringBuffer.append(TOKENS[(n6 & 0xF) << 2 | (n7 & 0xC0) >> 6]);
                    stringBuffer.append(TOKENS[n7 & 0x3F]);
                    n5 = 0;
                }
            }
            n6 = n7;
        }
        switch (n5) {
            case 1: {
                stringBuffer.append(TOKENS[(n6 & 3) << 4]);
                stringBuffer.append('=');
                stringBuffer.append('=');
                break;
            }
            case 2: {
                stringBuffer.append(TOKENS[(n6 & 0xF) << 2]);
                stringBuffer.append('=');
            }
        }
        String string = stringBuffer.toString();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode", (Object)string);
        }
        return string;
    }

    public static void encode(InputStream inputStream, Writer writer) throws IOException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"encode", (Object)new Object[]{inputStream, writer});
        }
        int n2 = 0;
        int n3 = 0;
        while ((n = inputStream.read()) != -1) {
            switch (n2) {
                case 0: {
                    writer.write(TOKENS[(n & 0xFC) >> 2]);
                    n2 = 1;
                    break;
                }
                case 1: {
                    writer.write(TOKENS[(n3 & 3) << 4 | (n & 0xF0) >> 4]);
                    n2 = 2;
                    break;
                }
                case 2: {
                    writer.write(TOKENS[(n3 & 0xF) << 2 | (n & 0xC0) >> 6]);
                    writer.write(TOKENS[n & 0x3F]);
                    n2 = 0;
                }
            }
            n3 = n;
        }
        switch (n2) {
            case 1: {
                writer.write(TOKENS[(n3 & 3) << 4]);
                writer.write(61);
                writer.write(61);
                break;
            }
            case 2: {
                writer.write(TOKENS[(n3 & 0xF) << 2]);
                writer.write(61);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"encode");
        }
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decode", (Object)string);
        }
        byte[] byArray = Base64.decode(string, 0, string.length());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decode", (Object)byArray);
        }
        return byArray;
    }

    public static byte[] decode(char[] cArray) {
        return Base64.decode(cArray, 0, cArray.length);
    }

    public static byte[] decode(char[] cArray, int n, int n2) {
        byte[] byArray;
        byte[] byArray2 = new byte[n2 / 4 * 3];
        int n3 = 0;
        int n4 = 0;
        byte by = 0;
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            byte by2;
            char c = cArray[i];
            if (c == '=') {
                if (n4 < 2) {
                    throw new IllegalArgumentException();
                }
                bl = true;
                break;
            }
            if (c < '\u0000' || c > '\u007f' || (by2 = TOKEN_VALUES[c]) == -1) continue;
            switch (n4) {
                case 0: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    byArray2[n3++] = (byte)(by << 2 | (by2 & 0x30) >> 4);
                    n4 = 2;
                    break;
                }
                case 2: {
                    byArray2[n3++] = (byte)((by & 0xF) << 4 | (by2 & 0x3C) >> 2);
                    n4 = 3;
                    break;
                }
                case 3: {
                    byArray2[n3++] = (byte)((by & 3) << 6 | by2);
                    n4 = 0;
                }
            }
            by = by2;
        }
        if (!bl && n4 != 0) {
            throw new IllegalArgumentException();
        }
        if (n3 < byArray2.length) {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
        } else {
            byArray = byArray2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decode", (Object)byArray);
        }
        return byArray;
    }

    public static byte[] decode(String string, int n, int n2) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decode", (Object)new Object[]{string, new Integer(n), new Integer(n2)});
        }
        byte[] byArray = Base64.decode(string.toCharArray(), n, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decode", (Object)byArray);
        }
        return byArray;
    }

    public static void decode(char[] cArray, OutputStream outputStream) throws IOException, IllegalArgumentException {
        Base64.decode(cArray, 0, cArray.length, outputStream);
    }

    public static void decode(char[] cArray, int n, int n2, OutputStream outputStream) throws IOException, IllegalArgumentException {
        outputStream.write(Base64.decode(cArray, n, n2));
    }

    public static void decode(String string, OutputStream outputStream) throws IOException, IllegalArgumentException {
        Base64.decode(string.toCharArray(), outputStream);
    }

    public static void decode(Reader reader, OutputStream outputStream) throws IOException, IllegalArgumentException {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decode", (Object)new Object[]{reader, outputStream});
        }
        int n2 = 0;
        byte by = 0;
        boolean bl = false;
        while ((n = reader.read()) != -1) {
            byte by2;
            if (n == 61) {
                if (n2 < 2) {
                    throw new IllegalArgumentException();
                }
                bl = true;
                break;
            }
            if (n < 0 || n > 127 || (by2 = TOKEN_VALUES[n]) == -1) continue;
            switch (n2) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    outputStream.write(by << 2 | (by2 & 0x30) >> 4);
                    n2 = 2;
                    break;
                }
                case 2: {
                    outputStream.write((by & 0xF) << 4 | (by2 & 0x3C) >> 2);
                    n2 = 3;
                    break;
                }
                case 3: {
                    outputStream.write((by & 3) << 6 | by2);
                    n2 = 0;
                }
            }
            by = by2;
        }
        if (!bl && n2 != 0) {
            throw new IllegalArgumentException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decode");
        }
    }

    static {
        int n;
        tc = Tr.register((Class)Base64.class, null, null);
        TOKENS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        TOKEN_VALUES = new byte[128];
        for (n = 0; n < TOKEN_VALUES.length; ++n) {
            Base64.TOKEN_VALUES[n] = -1;
        }
        for (n = 0; n < TOKENS.length; ++n) {
            Base64.TOKEN_VALUES[Base64.TOKENS[n]] = (byte)n;
        }
    }
}

