/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ssl.SSLConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;

public abstract class SSLServerSocketFactory
extends javax.net.ssl.SSLServerSocketFactory {
    private static TraceComponent tc = Tr.register((String)SSLServerSocketFactory.class.getName(), (String)"SSL");

    public abstract SSLConfig getConfig();

    public ServerSocket createServerSocket(int n) throws IOException {
        SSLServerSocket sSLServerSocket;
        try {
            SSLConfig sSLConfig = this.getConfig();
            sSLServerSocket = sSLConfig.configure(sSLConfig.getServerSocketFactory().createServerSocket(n));
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)tc, (String)"Unable to create server socket", (Object)iOException);
            throw iOException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Unable to create server socket", (Object)exception);
            throw new IOException(exception.getClass().getName() + ": " + exception.getMessage());
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        SSLServerSocket sSLServerSocket;
        try {
            SSLConfig sSLConfig = this.getConfig();
            sSLServerSocket = sSLConfig.configure(sSLConfig.getServerSocketFactory().createServerSocket(n, n2));
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)tc, (String)"Unable to create server socket", (Object)iOException);
            throw iOException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Unable to create server socket", (Object)exception);
            throw new IOException(exception.getClass().getName() + ": " + exception.getMessage());
        }
        return sSLServerSocket;
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocket sSLServerSocket;
        try {
            SSLConfig sSLConfig = this.getConfig();
            sSLServerSocket = sSLConfig.configure(sSLConfig.getServerSocketFactory().createServerSocket(n, n2, inetAddress));
        }
        catch (IOException iOException) {
            Tr.error((TraceComponent)tc, (String)"Unable to create server socket", (Object)iOException);
            throw iOException;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Unable to create server socket", (Object)exception);
            throw new IOException(exception.getClass().getName() + ": " + exception.getMessage());
        }
        return sSLServerSocket;
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getConfig().getServerSocketFactory().getSupportedCipherSuites();
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Unable to get supported cipher suites", (Object)exception);
            return null;
        }
    }

    public String[] getDefaultCipherSuites() {
        try {
            SSLConfig sSLConfig = this.getConfig();
            String[] stringArray = sSLConfig.getEnabledCipherSuites();
            if (stringArray == null) {
                stringArray = sSLConfig.getServerSocketFactory().getDefaultCipherSuites();
            }
            return stringArray;
        }
        catch (Exception exception) {
            Tr.error((TraceComponent)tc, (String)"Unable to get default cipher suites", (Object)exception);
            return null;
        }
    }
}

