/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.io.Stream;
import java.io.IOException;
import java.io.InputStream;

public class ContentLengthInputStream
extends Stream {
    protected int length;
    private int remaining = -1;
    private HttpConnection conn = null;
    private static TraceComponent tc = Tr.register((String)ContentLengthInputStream.class.getName(), (String)"HTTP_Transport");

    public ContentLengthInputStream(HttpConnection httpConnection) {
        this.conn = httpConnection;
    }

    public void init(InputStream inputStream, int n) {
        super.init(inputStream, null);
        this.remaining = this.length = n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init", (Object)new Integer(n));
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"read", (Object)new Object[]{new Integer(n), new Integer(n2)});
        }
        if (n2 > this.length) {
            n2 = this.length;
        }
        if (n2 <= 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"read", (Object)"-1");
            }
            return -1;
        }
        try {
            n3 = this.is.read(byArray, n, n2);
            if (n3 > 0) {
                this.length -= n3;
                this.remaining -= n3;
            } else {
                this.length = -1;
            }
        }
        catch (IOException iOException) {
            this.conn.setshouldStayAlive(false);
            throw iOException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"read", (Object)new Integer(n3));
        }
        return n3;
    }

    public int available() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"available", (Object)new Integer(this.length));
        }
        return this.length;
    }

    public void close() throws IOException {
        byte[] byArray = null;
        if (this.remaining > 0) {
            byArray = new byte[8192];
        }
        while (this.remaining > 0) {
            int n = this.is.read(byArray);
            if (n <= 0) continue;
            this.remaining -= n;
        }
        super.close();
    }
}

