/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.config;

import com.ibm.ws.exception.WsException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.ImplFactory;
import com.ibm.wtp.internal.encoders.EncoderDecoder;
import com.ibm.wtp.internal.encoders.EncoderDecoderRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;

public class ModelMgr {
    private static boolean initialized = false;

    public static void initialize(String string) {
        ModelMgr.initializeModels(string);
        if (initialized) {
            return;
        }
        try {
            EncoderDecoder encoderDecoder = (EncoderDecoder)ImplFactory.loadImplFromKey(EncoderDecoder.class);
            EncoderDecoderRegistry.getDefaultRegistry().setDefaultEncoderDecoder(encoderDecoder);
            initialized = true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IllegalStateException(throwable.getMessage());
        }
    }

    private static void initializeModels(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources("META-INF/" + string + "-model.init");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.ModelMgr", (String)"59");
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    try {
                        try {
                            if (string2.trim().length() <= 0) continue;
                            Class<?> clazz = classLoader.loadClass(string2);
                            Method method = clazz.getDeclaredMethod("init", null);
                            method.invoke(null, null);
                        }
                        catch (Exception exception) {
                            throw new WsException("Error processing plugin for " + uRL.toString() + " class: " + string2, (Throwable)exception);
                        }
                    }
                    catch (WsException wsException) {
                        FFDCFilter.processException((Throwable)wsException, (String)"com.ibm.ws.config.ModelMgr", (String)"116");
                    }
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.config.ModelMgr", (String)"82");
            }
        }
    }
}

