/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util;

import com.ibm.ejs.util.ExternalStore;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileStore
implements ExternalStore {
    private String rootDir;

    public FileStore() {
        this(System.getProperty("java.tmpdir"));
    }

    public FileStore(String string) {
        this.rootDir = string;
    }

    public String store(Object object) throws IOException {
        String string = Integer.toString(object.hashCode());
        this.store(string, object);
        return string;
    }

    public synchronized void store(Object object, Object object2) throws IOException {
        String string = object2.getClass().getName();
        String string2 = (String)object;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.rootDir + string2);
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(object2);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.util.FileStore.store", (String)"87", (Object)this);
        }
    }

    public synchronized Object retrieve(Object object) throws IOException, ClassNotFoundException {
        String string = (String)object;
        FileInputStream fileInputStream = new FileInputStream(this.rootDir + string);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(fileInputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
        Object object2 = objectInputStream.readObject();
        objectInputStream.close();
        File file = new File(this.rootDir + string);
        file.delete();
        return object2;
    }

    public static void main(String[] stringArray) {
        System.out.println(System.getProperties().toString());
        String string = null;
        if (stringArray.length != 0) {
            FileStore fileStore = new FileStore();
            Properties properties = new Properties();
            try {
                properties = (Properties)fileStore.retrieve(stringArray[0]);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.FileStore.main", (String)"117");
                System.out.println("FileStore test failed: " + exception.toString());
            }
            properties.list(System.out);
        } else {
            FileStore fileStore = new FileStore();
            System.out.println("New file store constructed");
            try {
                string = fileStore.store(System.getProperties());
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.util.FileStore.main", (String)"129");
                System.out.println("File Store test failed: " + iOException.toString());
            }
            System.out.println("Stored object in file: " + string);
        }
    }
}

