#!/usr/atria/bin/Perl
#------------------------------------------------------------
# ClearCase View Information Automation
#
#IBM Confidential
#OCO Source Materials
#Rational ClearCase
#(C) Copyright IBM Corp. 2002, 2006
#The source code for this program is not published or otherwise
#divested of its trade secrets, irrespective of what has been
#deposited with the U.S. Copyright Office.
#

$FolderPath = shift( @ARGV );

# $FolderPath =~ s/\\/\\\\/g;  # for Windows UNC path name parsing

# Check if Argument exist
if ( !$FolderPath )
{
	print "NONE";
	exit(0);
}

# Check Folder Path exist
if ( ! -e $FolderPath )
{
	print "NONE";
	exit(0);
}

chdir($FolderPath);

$ViewOutput = `${ctpath}cleartool lsview -long -cview`;

if (!$ViewOutput)
{	
	print "NONE";
	exit(0);
}
else
{
	print $ViewOutput;
	exit(1);
}


####
#
# This fixes some rather stupid behavior if cleartool isn't in the path!
#
BEGIN {

	### one of these ev's should be set if CC installed
	#   to some dir other than the default
	#
	$atriahome = $ENV{'ATRIAHOME'};
    $clearcasehome = $ENV{'CLEARCASEHOME'};

    if (-e "/usr/atria/bin/cleartool") {
	$ctpath = "/usr/atria/bin/";
    } elsif (-e "/opt/rational/clearcase/cleartool") { 
	$ctpath = "/opt/rational/clearcase/bin/";
    } elsif (defined($atriahome) && -e "${atriahome}/bin/cleartool") {
	$ctpath = $atriahome . "/bin/";
	} elsif (defined($clearcasehome) && -e "${clearcasehome}/bin/cleartool") {
	$ctpath = $clearcasehome . "/bin/";
    } else {
	# better pray cleartool is in the damn path!
	$ctpath = "";
    }

}
