/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo.wizard;

import com.ibm.xtt.gen.xsd.java.sdo.dialogs.JavaProjectSelectionDialog;
import com.ibm.xtt.gen.xsd.java.sdo.messages.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class SDOGeneratorWidget
extends SimpleWidgetDataContributor {
    private String projectName;
    private Text outputFolderText;
    private String outputFolderTextValue;
    private Button browseButton;
    private Combo javaVersionCombo;
    private IStructuredSelection initialSelection;
    private Composite advancedComposite;
    private Button useProjectCompilerComplianceLevelRadioButton;
    private Button otherCompilerComplianceLevelRadioButton;

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        topComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        topComposite.setLayoutData((Object)data);
        Composite composite = new Composite(topComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        Label projectLabel = new Label(composite, 16384);
        projectLabel.setText(Messages._UI_JAVA_GEN_LABEL_CONTAINER);
        data = new GridData();
        data.horizontalAlignment = 4;
        projectLabel.setLayoutData((Object)data);
        this.outputFolderText = new Text(composite, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 10;
        this.outputFolderText.setLayoutData((Object)data);
        this.outputFolderText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                SDOGeneratorWidget.this.outputFolderTextValue = SDOGeneratorWidget.this.outputFolderText.getText();
                statusListener.handleEvent(event);
            }
        });
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(Messages._UI_JAVA_GEN_BUTTON_BROWSE);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addSelectionListener((SelectionListener)new BrowseListener());
        final Button advancedButton = new Button(composite, 0);
        advancedButton.setText(Messages._UI_JAVA_GEN_VALUE_ADVANCED_BUTTON_COLLAPSED);
        data = new GridData();
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        advancedButton.setLayoutData((Object)data);
        advancedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (SDOGeneratorWidget.this.advancedComposite.isVisible()) {
                    SDOGeneratorWidget.this.advancedComposite.setVisible(false);
                    advancedButton.setText(Messages._UI_JAVA_GEN_VALUE_ADVANCED_BUTTON_COLLAPSED);
                } else {
                    SDOGeneratorWidget.this.advancedComposite.setVisible(true);
                    advancedButton.setText(Messages._UI_JAVA_GEN_VALUE_ADVANCED_BUTTON_EXPANDED);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.advancedComposite = new Composite(composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.advancedComposite.setLayoutData((Object)data);
        this.advancedComposite.setLayout((Layout)new GridLayout());
        this.advancedComposite.setVisible(false);
        Group jdkCompliance = new Group(this.advancedComposite, 0);
        data = new GridData(1808);
        jdkCompliance.setLayoutData((Object)data);
        jdkCompliance.setLayout((Layout)new GridLayout(2, false));
        jdkCompliance.setText(Messages._UI_JDK_COMPLIANE);
        this.useProjectCompilerComplianceLevelRadioButton = new Button((Composite)jdkCompliance, 16);
        data = new GridData();
        data.horizontalSpan = 2;
        this.useProjectCompilerComplianceLevelRadioButton.setLayoutData((Object)data);
        this.otherCompilerComplianceLevelRadioButton = new Button((Composite)jdkCompliance, 16);
        this.otherCompilerComplianceLevelRadioButton.setText(Messages._UI_COMPLIANCE_OTHER);
        this.otherCompilerComplianceLevelRadioButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SDOGeneratorWidget.this.javaVersionCombo.setEnabled(SDOGeneratorWidget.this.otherCompilerComplianceLevelRadioButton.getSelection());
            }
        });
        this.javaVersionCombo = new Combo((Composite)jdkCompliance, 8);
        GenJDKLevel[] genJDKLevels = GenJDKLevel.values();
        int i = 0;
        while (i < genJDKLevels.length) {
            this.javaVersionCombo.add(this.formatComplianceString(genJDKLevels[i].getLiteral(), true));
            ++i;
        }
        this.javaVersionCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                statusListener.handleEvent(event);
            }
        });
        return super.addControls(parent, statusListener);
    }

    private String getContainerErrorMessage() {
        String pathString = this.outputFolderText.getText();
        IContainer specifiedContainer = this.getSpecifiedContainer(pathString);
        if (specifiedContainer == null) {
            return Messages._ERROR_THE_CONTAINER_NAME;
        }
        if (specifiedContainer instanceof IProject) {
            if (!this.isJavaProject((IProject)specifiedContainer)) {
                return Messages._ERROR_NOT_JAVA_PROJECT;
            }
            IPath specifiedPath = this.getJavaSourcePath((IProject)specifiedContainer);
            if (specifiedPath != null) {
                return Messages._ERROR_USE_PROJECT_JAVA_SOURCE_FOLDER;
            }
        } else if (specifiedContainer instanceof IFolder) {
            IFolder folder = (IFolder)specifiedContainer;
            IProject proj = folder.getProject();
            if (!this.isJavaProject(proj)) {
                return Messages._ERROR_NOT_JAVA_PROJECT;
            }
            IJavaProject javaProj = JavaCore.create((IProject)proj);
            try {
                IPackageFragmentRoot jRoot = null;
                jRoot = javaProj.findPackageFragmentRoot(specifiedContainer.getFullPath());
                if (jRoot == null) {
                    return Messages._ERROR_CONTAINER_NOT_JAVA_BUILDPATH;
                }
            }
            catch (JavaModelException e) {
                return e.toString();
            }
        }
        return null;
    }

    private String getJavaProject(IContainer currentContainer) {
        IProject javaProj;
        String result = "/";
        if ((result = String.valueOf(result) + this.walkContainerPath(currentContainer)).equals("/") && (javaProj = this.findJavaProject()) != null) {
            result = String.valueOf(result) + this.findJavaProject().getName();
        }
        return result;
    }

    private IProject findJavaProject() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        IProject result = null;
        int i = 0;
        while (i < projects.length) {
            boolean done = this.isJavaProject(projects[i]);
            if (done) {
                result = projects[i];
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isJavaProject(IProject project) {
        boolean result = false;
        try {
            result = project.getDescription().hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (Exception exception) {
            return result;
        }
        return result;
    }

    private IContainer getSpecifiedContainer(String pathString) {
        IPath path = this.getContainerFullPath(pathString);
        if (path == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().exists(path)) {
            return (IContainer)workspace.getRoot().findMember(path);
        }
        return null;
    }

    private IPath getContainerFullPath(String pathString) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (pathString.equals("")) {
            return null;
        }
        IStatus result = workspace.validatePath(pathString, 6);
        if (result.isOK()) {
            return new Path(pathString);
        }
        return null;
    }

    private IPath getJavaSourcePath(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProject.getRawClasspath();
        }
        catch (JavaModelException ex) {
            ex.printStackTrace();
            return null;
        }
        IClasspathEntry firstSource = null;
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 3 && firstSource == null) {
                firstSource = cp[i];
            }
            ++i;
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(project.getName()) && !firstSource.getPath().removeFirstSegments(1).toString().equals("")) {
            return firstSource.getPath();
        }
        return null;
    }

    private String walkContainerPath(IContainer container) {
        String result = "";
        if (container instanceof IProject) {
            result = this.isJavaProject((IProject)container) ? String.valueOf(result) + container.getName() : String.valueOf(result) + this.walkContainerPath(container.getParent());
        } else if (container != null) {
            result = String.valueOf(result) + this.walkContainerPath(container.getParent());
        }
        return result;
    }

    public String getOutputLocation() {
        return this.outputFolderText.getText();
    }

    private void setDestinationFolder(String folder) {
        this.outputFolderTextValue = folder;
    }

    public IStatus getStatus() {
        String containerErrorMessage = this.getContainerErrorMessage();
        if (containerErrorMessage != null) {
            return new Status(4, "id", 0, containerErrorMessage, null);
        }
        String compilerComplianceLevelWarning = this.getCompilerComplianceLevelWarning();
        if (compilerComplianceLevelWarning != null) {
            return new Status(2, "id", 0, compilerComplianceLevelWarning, null);
        }
        return null;
    }

    private String getCompilerComplianceLevelWarning() {
        String selectedComplianceLevel;
        int index;
        String projectComplianceLevel = this.getProjectComplianceLevel();
        if (projectComplianceLevel != null && (index = this.javaVersionCombo.getSelectionIndex()) != -1 && !projectComplianceLevel.equals(selectedComplianceLevel = this.javaVersionCombo.getItem(index))) {
            return Messages._WARN_COMPILER_COMPLIANCE_LEVEL_DOES_NOT_MATCH;
        }
        return null;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public GenJDKLevel getComplianceLevel() {
        return GenJDKLevel.values()[this.javaVersionCombo.getSelectionIndex()];
    }

    public IStructuredSelection getInitialSelection() {
        return this.initialSelection;
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.initialSelection = initialSelection;
        this.setOutputFolderValue();
    }

    private IStructuredSelection getCurrentSelection() {
        IResource resource;
        Path path;
        IProject project;
        IJavaProject javaProject;
        StructuredSelection selection = null;
        if (this.projectName != null && !"/".equals(this.projectName) && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName)))) != null && (path = new Path(this.outputFolderText.getText())) != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path)) != null) {
            IPackageFragmentRoot packageFragmentRoot = javaProject.getPackageFragmentRoot(resource);
            selection = new StructuredSelection((Object)packageFragmentRoot);
        }
        return selection;
    }

    private void setOutputFolderValue() {
        IContainer baseContainer = null;
        Object element = null;
        if (this.initialSelection != null && (element = this.initialSelection.getFirstElement()) instanceof IFile) {
            baseContainer = ((IFile)element).getParent();
        }
        this.projectName = this.getJavaProject(baseContainer);
        this.updateCompilerComplianceValue();
        IContainer specifiedContainer = this.getSpecifiedContainer(this.projectName);
        IPath specifiedPath = this.getJavaSourcePath((IProject)specifiedContainer);
        if (specifiedPath != null) {
            this.setDestinationFolder(specifiedPath.toString());
        } else {
            this.setDestinationFolder(this.projectName);
        }
        this.outputFolderText.setText(this.outputFolderTextValue);
    }

    private void updateCompilerComplianceValue() {
        String projectComplianceLevel = this.getProjectComplianceLevel();
        MessageFormat messageFormat = new MessageFormat(Messages._UI_USER_PROJECT_DEFINED_COMPLIANCE_LEVEL);
        String message = messageFormat.format(new String[]{projectComplianceLevel});
        this.useProjectCompilerComplianceLevelRadioButton.setText(message);
        this.useProjectCompilerComplianceLevelRadioButton.pack();
        if (GenJDKLevel.get((String)this.formatComplianceString(this.getProjectComplianceLevel(), false)) != null) {
            this.useProjectCompilerComplianceLevelRadioButton.setEnabled(true);
            if (!this.otherCompilerComplianceLevelRadioButton.getSelection()) {
                this.javaVersionCombo.setEnabled(false);
                this.useProjectCompilerComplianceLevelRadioButton.setSelection(true);
            }
        } else {
            this.useProjectCompilerComplianceLevelRadioButton.setEnabled(false);
            this.javaVersionCombo.setEnabled(true);
            this.otherCompilerComplianceLevelRadioButton.setSelection(true);
            this.useProjectCompilerComplianceLevelRadioButton.setSelection(false);
        }
        if (projectComplianceLevel != "") {
            String[] items = this.javaVersionCombo.getItems();
            int index = 0;
            int i = 0;
            while (i < items.length) {
                if (projectComplianceLevel.equals(items[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
            this.javaVersionCombo.select(index);
        } else {
            this.javaVersionCombo.select(0);
        }
    }

    private String getProjectComplianceLevel() {
        IProject project;
        IJavaProject javaProject;
        if (this.projectName != null && !"/".equals(this.projectName) && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName)))) != null) {
            return javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        return "";
    }

    private String formatComplianceString(String level, boolean fromGenJDKLevel) {
        if (fromGenJDKLevel) {
            if ("5.0".equals(level)) {
                level = "1.5";
            } else if ("6.0".equals(level)) {
                level = "1.6";
            }
        } else if ("1.5".equals(level)) {
            level = "5.0";
        } else if ("1.6".equals(level)) {
            level = "6.0";
        }
        return level;
    }

    public class BrowseListener
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Shell shell = Display.getCurrent().getActiveShell();
            JavaProjectSelectionDialog queryJavaProjectDialog = new JavaProjectSelectionDialog(shell, SDOGeneratorWidget.this.getCurrentSelection(), true);
            queryJavaProjectDialog.setBlockOnOpen(true);
            IJavaModel root = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IPackageFragmentRoot jRoot = null;
            if (queryJavaProjectDialog.open(root) == 0) {
                IJavaElement element = queryJavaProjectDialog.getJavaElement();
                if (element instanceof IJavaProject) {
                    IJavaProject jProject = (IJavaProject)element;
                    jRoot = jProject.getPackageFragmentRoot((IResource)jProject.getProject());
                    SDOGeneratorWidget.this.projectName = jProject.getElementName();
                } else if (element instanceof IPackageFragmentRoot) {
                    jRoot = (IPackageFragmentRoot)element;
                    SDOGeneratorWidget.this.projectName = jRoot.getJavaProject().getElementName();
                }
                SDOGeneratorWidget.this.updateCompilerComplianceValue();
                if (jRoot != null) {
                    SDOGeneratorWidget.this.outputFolderText.setText(jRoot.getPath().toString());
                }
            }
        }
    }
}

