/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtt.gen.xsd.java.sdo;

import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.osgi.framework.Bundle;

public class WDOGenerator {
    private Map ePackageToInformationMap;
    private Vector utilInfo = new Vector();
    private String modelDirectoryName;
    private String packageName;
    private GenJDKLevel complianceLevel;

    public void generate(URI uri) throws Exception {
        GenModel genModel = this.buildGenModel(uri);
        this.generateWDO(genModel);
        this.generateResourceUtil();
    }

    public void setModelDirectoryName(String name) {
        this.modelDirectoryName = name;
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public void setComplianceLevel(GenJDKLevel complianceLevel) {
        this.complianceLevel = complianceLevel;
    }

    private GenModel buildGenModel(URI uri) throws Exception {
        List ecoreModels = this.generateECoreModels(uri);
        this.traversePackages(ecoreModels);
        return this.createGenModel(ecoreModels);
    }

    private List generateECoreModels(URI uri) throws Exception {
        ArrayList ecoreModels = new ArrayList();
        URI xmlSchemaModelLocation = uri;
        ecoreModels.clear();
        XSDEcoreBuilder ecoreGenerator = new XSDEcoreBuilder();
        ecoreModels.addAll(ecoreGenerator.generate(xmlSchemaModelLocation));
        if (ecoreModels.isEmpty()) {
            throw new Exception("Specify a valid XML Schema and try loading again.");
        }
        return ecoreModels;
    }

    private void traversePackages(Collection ePackages) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.ePackageToInformationMap = new HashMap();
        for (EPackage ePackage : ePackages) {
            String qualifiedName;
            ArrayList<String> packageInformation = new ArrayList<String>();
            this.ePackageToInformationMap.put(ePackage, packageInformation);
            ArrayList<StringBuffer> ecoreFileNameInformation = new ArrayList<StringBuffer>();
            if (this.packageName != null) {
                qualifiedName = this.packageName;
                ePackage.setName(this.packageName);
                ePackage.setNsPrefix(qualifiedName);
            } else {
                qualifiedName = ePackage.getName();
            }
            String ecoreFileName = String.valueOf(qualifiedName) + ".ecore";
            int index = qualifiedName.lastIndexOf(".");
            if (index != -1) {
                packageInformation.add(qualifiedName.substring(0, index));
                ePackage.setName(qualifiedName.substring(index + 1));
            } else {
                packageInformation.add(null);
            }
            URI ecoreURI = URI.createPlatformResourceURI((String)ecoreFileName);
            Resource resource = resourceSet.getResource(ecoreURI, false);
            if (resource == null) {
                resource = resourceSet.createResource(ecoreURI);
            }
            resource.getContents().add((Object)ePackage);
            String prefix = ePackage.getName();
            packageInformation.add(String.valueOf(Character.toUpperCase(prefix.charAt(0))) + prefix.substring(1));
            ecoreFileNameInformation.add(new StringBuffer(ecoreFileName));
            this.utilInfo.add(new String[]{qualifiedName, prefix});
        }
    }

    private GenModel createGenModel(List ecoreModels) throws Exception {
        String modelName;
        int index;
        ArrayList referencedGenPackages = new ArrayList();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI genModelURI = URI.createFileURI((String)"default.genmodel");
        Resource genModelResource = resourceSet.createResource(genModelURI);
        GenModelFactory genModelFactory = GenModelFactory.eINSTANCE;
        GenModel genModel = genModelFactory.createGenModel();
        genModelResource.getContents().add((Object)genModel);
        genModel.initialize((Collection)ecoreModels);
        genModel.getUsedGenPackages().addAll(referencedGenPackages);
        if (!genModel.getGenPackages().isEmpty()) {
            this.traverseGenPackages((List)genModel.getGenPackages());
            GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
            while (genPackage.getGenClassifiers().isEmpty() && !genPackage.getNestedGenPackages().isEmpty()) {
                genPackage = (GenPackage)genPackage.getNestedGenPackages().get(0);
            }
            genPackage.setResource(GenResourceKind.XML_LITERAL);
        }
        if ((index = (modelName = "default.genmodel").lastIndexOf(46)) != -1) {
            modelName = modelName.substring(0, index);
        }
        modelName = String.valueOf(Character.toUpperCase(modelName.charAt(0))) + modelName.substring(1);
        genModel.setModelName(modelName);
        genModel.setModelDirectory(this.modelDirectoryName);
        return genModel;
    }

    private void traverseGenPackages(List genPackages) {
        for (GenPackage genPackage : genPackages) {
            EPackage ePackage = genPackage.getEcorePackage();
            List ePackageInformation = (List)this.ePackageToInformationMap.get(ePackage);
            if (ePackageInformation != null) {
                genPackage.setBasePackage((String)ePackageInformation.get(0));
                genPackage.setPrefix((String)ePackageInformation.get(1));
            }
            if (genPackage.getPrefix() == null || genPackage.getPrefix().length() == 0) {
                String name = ePackage.getName();
                genPackage.setPrefix(String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1));
            }
            this.traverseGenPackages((List)genPackage.getNestedGenPackages());
        }
    }

    private void generateWDO(GenModel genModel) throws Exception {
        genModel.setForceOverwrite(true);
        genModel.setRedirection("");
        genModel.setCanGenerate(true);
        genModel.setUpdateClasspath(false);
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("org.eclipse.emf.ecore.sdo.InternalEDataObject");
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.eclipse.emf.ecore.sdo.util.ESequence");
        genModel.setFeatureMapWrapperClass("org.eclipse.emf.ecore.sdo.util.BasicESequence");
        genModel.setSuppressEMFTypes(true);
        if (this.complianceLevel != null) {
            genModel.setComplianceLevel(this.complianceLevel);
        }
        ArrayList<String> modelPluginVariableAdditions = new ArrayList<String>();
        modelPluginVariableAdditions.add("EMF_COMMONJ_SDO=org.eclipse.emf.commonj.sdo");
        modelPluginVariableAdditions.add("EMF_ECORE_SDO=org.eclipse.emf.ecore.sdo");
        modelPluginVariableAdditions.removeAll((Collection<?>)genModel.getModelPluginVariables());
        if (!modelPluginVariableAdditions.isEmpty()) {
            Iterator iterator = modelPluginVariableAdditions.iterator();
            while (iterator.hasNext()) {
                genModel.getModelPluginVariables().add((Object)((String)iterator.next()));
            }
        }
        ArrayList<String> staticPackageURIAdditions = new ArrayList<String>();
        staticPackageURIAdditions.add("http://www.eclipse.org/emf/2003/SDO");
        staticPackageURIAdditions.removeAll((Collection<?>)genModel.getStaticPackages());
        if (!staticPackageURIAdditions.isEmpty()) {
            Iterator iterator = staticPackageURIAdditions.iterator();
            while (iterator.hasNext()) {
                genModel.getStaticPackages().add((Object)((String)iterator.next()));
            }
        }
        genModel.generate((IProgressMonitor)new NullProgressMonitor());
    }

    private void generateResourceUtil() throws Exception {
        int character;
        Bundle bundle = Platform.getBundle((String)"com.ibm.xtt.gen.xsd.java.sdo");
        URL url = bundle.getEntry("/templates/ResourceUtil.template");
        InputStream inputStream = url.openStream();
        StringBuffer stringBuffer = new StringBuffer();
        while ((character = inputStream.read()) != -1) {
            stringBuffer.append((char)character);
        }
        inputStream.close();
        String qualifiedName = null;
        String prefix = null;
        String sourceRootDir = String.valueOf(Platform.getLocation().toString()) + this.modelDirectoryName;
        int i = 0;
        while (i < this.utilInfo.size()) {
            qualifiedName = ((String[])this.utilInfo.get(i))[0];
            prefix = ((String[])this.utilInfo.get(i))[1];
            String string = stringBuffer.toString();
            string = string.replaceAll("\\$\\{base\\_package\\}", qualifiedName);
            string = string.replaceAll("\\$\\{factory\\}", String.valueOf(this.toProperCase(prefix)) + "Factory");
            string = string.replaceAll("\\$\\{package\\}", String.valueOf(this.toProperCase(prefix)) + "Package");
            string = string.replaceAll("\\$\\{prefix\\}", this.toProperCase(prefix));
            String subPath = "/" + qualifiedName.replaceAll("\\.", "/").concat("/util/" + this.toProperCase(prefix) + "ResourceUtil.java");
            String outfile = String.valueOf(sourceRootDir) + subPath;
            FileWriter writer = new FileWriter(outfile);
            writer.write(string);
            writer.close();
            ++i;
        }
    }

    private String toProperCase(String string) {
        String first = string.substring(0, 1);
        String rest = string.substring(1);
        return first.toUpperCase().concat(rest);
    }
}

