/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2se.quickfix;

import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class NonPrivateNativeQuickFix
extends JavaCodeReviewQuickFix {
    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        MethodDeclaration md = (MethodDeclaration)theNode;
        if (md != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)md);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            ListRewrite lr = rewriter.getListRewrite((ASTNode)md, MethodDeclaration.MODIFIERS2_PROPERTY);
            Modifier oldMod = this.getReplacingModifier(md.modifiers());
            Modifier newMod = ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD);
            if (oldMod == null) {
                lr.insertLast((ASTNode)newMod, null);
            } else {
                rewriter.replace((ASTNode)oldMod, (ASTNode)newMod, null);
            }
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private Modifier getReplacingModifier(List modifiers) {
        Modifier mod2 = null;
        for (Modifier mod2 : modifiers) {
            Modifier.ModifierKeyword keyword = mod2.getKeyword();
            if (Modifier.ModifierKeyword.PUBLIC_KEYWORD.equals(keyword)) {
                return mod2;
            }
            if (!Modifier.ModifierKeyword.PROTECTED_KEYWORD.equals(keyword)) continue;
            return mod2;
        }
        return null;
    }
}

