/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2se;

import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.SuperClassRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class CheckStubRule
extends AbstractAnalysisRule {
    private static final String SECURITY_MANAGER_CLASS = "java.lang.SecurityManager";
    private static final String CHECK_METHOD = "check";
    private static final SuperClassRuleFilter TDFILTER = new SuperClassRuleFilter("java.lang.SecurityManager", true);

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(historyId, "codereview.java.resource");
        List tds = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 55);
        ASTHelper.satisfy((List)tds, (IRuleFilter)TDFILTER);
        for (TypeDeclaration td : tds) {
            if (td.isInterface()) continue;
            MethodDeclaration[] mds = td.getMethods();
            int j = 0;
            while (j < mds.length) {
                if (mds[j].getName().getIdentifier().startsWith(CHECK_METHOD)) {
                    Statement s;
                    Block b = mds[j].getBody();
                    List statements = b.statements();
                    int statementCount = statements.size();
                    boolean empty = false;
                    if (statementCount == 0) {
                        empty = true;
                    } else if (statementCount == 1 && (s = (Statement)statements.get(0)).getNodeType() == 20) {
                        empty = true;
                    }
                    if (empty) {
                        resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)mds[j]);
                    }
                }
                ++j;
            }
        }
    }
}

