/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.security.j2ee;

import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class InstanciatingClassLoaderRule
extends AbstractAnalysisRule {
    private static final String CLASS_LOADER_CLASS = "java.lang.ClassLoader";

    public void analyze(AnalysisHistory history) {
        String historyId = history.getHistoryId();
        CodeReviewResource resource = (CodeReviewResource)this.getProvider().getProperty(historyId, "codereview.java.resource");
        List cics = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 14);
        for (ClassInstanceCreation cic : cics) {
            ITypeBinding type;
            IMethodBinding methodBinding = cic.resolveConstructorBinding();
            ITypeBinding iTypeBinding = type = methodBinding != null ? methodBinding.getDeclaringClass() : null;
            if (type == null || !ASTHelper.instanceOf((ITypeBinding)type, (String)CLASS_LOADER_CLASS)) continue;
            resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)cic);
        }
    }
}

