/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.speed.quickfix;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.xtools.analysis.codereview.java.j2se.Messages;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RulePerformanceCollectionsWithSizeQuickFix
extends JavaCodeReviewQuickFix {
    private static final String NUMBER = "10";
    private ClassInstanceCreation cic = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.cic = null;
        if (theNode instanceof ClassInstanceCreation) {
            this.cic = (ClassInstanceCreation)theNode;
        }
        if (this.cic != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.cic);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.DIALOG_TITLE_RULE_PERFORMANCE_COLLECTIONSWITHOUTSIZE_QUICKFIX, Messages.DIALOG_MESSAGE_RULE_PERFORMANCE_COLLECTIONSWITHOUTSIZE_QUICKFIX, NUMBER, new IInputValidator(){

                public String isValid(String newText) {
                    int i = newText.length();
                    while (--i >= 0) {
                        if (Character.isDigit((char)UCharacter.codePointAt((String)newText, (int)i))) continue;
                        return Messages.DIALOG_ERROR_RULE_PERFORMANCE_COLLECTIONSWITHOUTSIZE_QUICKFIX;
                    }
                    return null;
                }
            });
            if (dlg.open() == 0) {
                String newSize = NUMBER;
                String theValue = dlg.getValue();
                if (theValue != null || !Collator.getInstance().equals("", theValue)) {
                    newSize = theValue;
                }
                ListRewrite lr = rewriter.getListRewrite((ASTNode)this.cic, ClassInstanceCreation.ARGUMENTS_PROPERTY);
                NumberLiteral numLit = ast.newNumberLiteral();
                numLit.setToken(newSize);
                lr.insertFirst((ASTNode)numLit, null);
                MultiTextEdit edits = new MultiTextEdit();
                edits.addChild(rewriter.rewriteAST(docToChange, null));
                return edits;
            }
            return null;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }
}

