/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.memory.quickfix;

import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class RulePerformanceNewBooleanQuickFix
extends JavaCodeReviewQuickFix {
    private static final String FIX1 = "Boolean.valueOf( %1% )";
    private static final String TAG_1 = "%1%";
    private ClassInstanceCreation cic = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.cic = null;
        if (theNode instanceof ClassInstanceCreation) {
            this.cic = (ClassInstanceCreation)theNode;
        }
        if (this.cic != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.cic);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            String arg = this.cic.arguments().get(0).toString();
            String line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)arg);
            ASTNode replace = rewriter.createStringPlaceholder(line, 32);
            rewriter.replace((ASTNode)this.cic, replace, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }
}

