/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.memory;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.InfixExpression;

public class RulePerformanceStringPlusInLoops
extends AbstractCodeReviewRule {
    private static final String STRINGTYPE = "java.lang.String";
    private static final String PLUS = "+";
    private static final String PLUSEQUALS = "+=";

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 24);
        this.findMiMatch(history.getHistoryId(), resource, list);
        list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 70);
        this.findMiMatch(history.getHistoryId(), resource, list);
        list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 61);
        this.findMiMatch(history.getHistoryId(), resource, list);
    }

    private void findMiMatch(String historyId, CodeReviewResource resource, List list) {
        for (ASTNode node : list) {
            List infixList = resource.getTypedNodeList(node, 27);
            for (InfixExpression infix : infixList) {
                String typeName;
                if (!Collator.getInstance().equals(PLUS, infix.getOperator().toString()) || (typeName = ASTHelper.getDataType((ASTNode)infix.getLeftOperand())) == null || !Collator.getInstance().equals(STRINGTYPE, typeName)) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)infix);
            }
            List assignList = resource.getTypedNodeList(node, 7);
            for (Assignment assign : assignList) {
                String typeName;
                if (!Collator.getInstance().equals(PLUSEQUALS, assign.getOperator().toString()) || (typeName = ASTHelper.getDataType((ASTNode)assign.getLeftHandSide())) == null || !Collator.getInstance().equals(STRINGTYPE, typeName)) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)assign);
            }
        }
    }
}

