/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.memory;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.MethodNameRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class RulePerformancePrimitiveTypeTemporaries
extends AbstractCodeReviewRule {
    private static final String METHODNAME = "toString";
    private static final String CLASS1 = "java.lang.Integer";
    private static final String CLASS2 = "java.lang.Character";
    private static final String CLASS3 = "java.lang.Double";
    private static final String CLASS4 = "java.lang.Float";
    private static final String CLASS5 = "java.lang.Long";
    private static final String CLASS6 = "java.lang.Byte";
    private static final String CLASS7 = "java.lang.String";
    IRuleFilter[] MIFILTERS = new IRuleFilter[]{new MethodNameRuleFilter("toString", true)};

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 32);
        ASTHelper.satisfy((List)list, (IRuleFilter[])this.MIFILTERS);
        for (MethodInvocation mi : list) {
            List cicList = resource.getTypedNodeList((ASTNode)mi, 14, false);
            for (ClassInstanceCreation cic : cicList) {
                IMethodBinding binding = cic.resolveConstructorBinding();
                if (binding == null) continue;
                String className = binding.getDeclaringClass().getQualifiedName();
                if (!Collator.getInstance().equals(CLASS1, className) && !Collator.getInstance().equals(CLASS2, className) && !Collator.getInstance().equals(CLASS3, className) && !Collator.getInstance().equals(CLASS4, className) && !Collator.getInstance().equals(CLASS5, className) && !Collator.getInstance().equals(CLASS6, className) && !Collator.getInstance().equals(CLASS7, className)) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, history.getHistoryId(), (ASTNode)mi);
            }
        }
    }
}

