/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.performance.memory;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.MethodNameRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ParameterCountRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ReturnTypeRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;

public class RulePerformanceExplicitFinalize
extends AbstractCodeReviewRule {
    private static final String VOID_TYPE = "void";
    private static final String FINALIZE_METHOD = "finalize";
    IRuleFilter[] MIFILTERS = new IRuleFilter[]{new MethodNameRuleFilter("finalize", true), new ParameterCountRuleFilter(0, true), new ReturnTypeRuleFilter("void", true)};

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 55);
        this.findMatchExpression(history.getHistoryId(), resource, list);
        list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 1);
        this.findMatchExpression(history.getHistoryId(), resource, list);
    }

    private void findMatchExpression(String historyId, CodeReviewResource resource, List list) {
        for (ASTNode td : list) {
            ITypeBinding returnBinding;
            Type returnType;
            IMethodBinding methodBinding;
            List mdList = resource.getTypedNodeList(td, 31, false);
            for (MethodDeclaration md : mdList) {
                methodBinding = md.resolveBinding();
                returnType = md.getReturnType2();
                ITypeBinding iTypeBinding = returnBinding = returnType != null ? returnType.resolveBinding() : null;
                if (methodBinding == null || returnBinding == null || !Modifier.isStatic((int)md.getModifiers()) && Collator.getInstance().equals(FINALIZE_METHOD, methodBinding.getName()) && Collator.getInstance().equals(VOID_TYPE, returnBinding.getName()) && md.parameters().size() == 0) continue;
                List miList = resource.getTypedNodeList((ASTNode)md, 32, true);
                ASTHelper.satisfy((List)miList, (IRuleFilter[])this.MIFILTERS);
                resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, (Collection)miList);
                miList = resource.getTypedNodeList((ASTNode)md, 48, true);
                ASTHelper.satisfy((List)miList, (IRuleFilter[])this.MIFILTERS);
                resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, (Collection)miList);
            }
            mdList = resource.getTypedNodeList(td, 31, false);
            for (MethodDeclaration md : mdList) {
                methodBinding = md.resolveBinding();
                returnType = md.getReturnType2();
                ITypeBinding iTypeBinding = returnBinding = returnType != null ? returnType.resolveBinding() : null;
                if (methodBinding == null || returnBinding == null || Modifier.isStatic((int)md.getModifiers()) && !Collator.getInstance().equals(FINALIZE_METHOD, methodBinding.getName()) && !Collator.getInstance().equals(VOID_TYPE, returnBinding.getName()) && md.parameters().size() == 0) continue;
                this.findMiMatch(historyId, resource, md);
                this.findSuperMiMatch(historyId, resource, md);
            }
        }
    }

    private void findMiMatch(String historyId, CodeReviewResource resource, MethodDeclaration md) {
        List miList = resource.getTypedNodeList((ASTNode)md, 32, true);
        ASTHelper.satisfy((List)miList, (IRuleFilter[])this.MIFILTERS);
        Iterator it3 = miList.iterator();
        while (it3.hasNext()) {
            MethodInvocation mi = (MethodInvocation)it3.next();
            List tryList = resource.getTypedNodeList((ASTNode)mi, 54, true);
            for (TryStatement tryStmt : tryList) {
                if (!tryStmt.getBody().equals((Object)tryStmt.getFinally())) continue;
                List miTryList = resource.getTypedNodeList((ASTNode)tryStmt, 32, true);
                int count = 0;
                Iterator it5 = miTryList.iterator();
                while (it5.hasNext()) {
                    MethodInvocation miTry = (MethodInvocation)it3.next();
                    if (!miTry.equals((Object)mi)) continue;
                    ++count;
                }
                if (count == 0) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)mi);
            }
        }
    }

    private void findSuperMiMatch(String historyId, CodeReviewResource resource, MethodDeclaration md) {
        List miList = resource.getTypedNodeList((ASTNode)md, 48, true);
        ASTHelper.satisfy((List)miList, (IRuleFilter[])this.MIFILTERS);
        Iterator it3 = miList.iterator();
        while (it3.hasNext()) {
            SuperMethodInvocation mi = (SuperMethodInvocation)it3.next();
            List tryList = resource.getTypedNodeList((ASTNode)mi, 54, true);
            for (TryStatement tryStmt : tryList) {
                if (!tryStmt.getBody().equals((Object)tryStmt.getFinally())) continue;
                List miTryList = resource.getTypedNodeList((ASTNode)tryStmt, 48, true);
                int count = 0;
                Iterator it5 = miTryList.iterator();
                while (it5.hasNext()) {
                    SuperMethodInvocation miTry = (SuperMethodInvocation)it3.next();
                    if (!miTry.equals((Object)mi)) continue;
                    ++count;
                }
                if (count == 0) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)mi);
            }
        }
    }
}

