/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.designprinciples.complexity;

import com.ibm.icu.text.NumberFormat;
import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.EnclosingNodeRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class RuleNestedIf
extends AbstractCodeReviewRule {
    private static final String DEPTHVARIABLE = "DEPTHVARIABLE";
    private int maxDepth;

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        try {
            List ifList;
            this.maxDepth = NumberFormat.getNumberInstance().parse(this.getParameter(DEPTHVARIABLE).getValue()).intValue();
            HashSet visited = new HashSet(10);
            List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 55);
            for (TypeDeclaration td : list) {
                ifList = resource.getTypedNodeList((ASTNode)td, 25);
                ASTHelper.satisfy((List)ifList, (IRuleFilter)new EnclosingNodeRuleFilter((ASTNode)td, true));
                this.findMatchExpression(history.getHistoryId(), resource, ifList, visited);
            }
            list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 1);
            for (TypeDeclaration td : list) {
                ifList = resource.getTypedNodeList((ASTNode)td, 25);
                ASTHelper.satisfy((List)ifList, (IRuleFilter)new EnclosingNodeRuleFilter((ASTNode)td, true));
                this.findMatchExpression(history.getHistoryId(), resource, ifList, visited);
            }
        }
        catch (ParseException e) {
            Log.severe((String)"", (Throwable)e);
        }
    }

    private void findMatchExpression(String historyId, CodeReviewResource resource, List ifList, Set visited) {
        for (IfStatement stmt : ifList) {
            List nestedIfList = resource.getTypedNodeList((ASTNode)stmt, 25);
            for (IfStatement inner : nestedIfList) {
                if (visited.contains(inner)) continue;
                visited.add(inner);
                if (this.levelIfNest((ASTNode)inner, (ASTNode)stmt) <= this.maxDepth) continue;
                resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)inner);
            }
        }
    }

    private int levelIfNest(ASTNode current, ASTNode root) {
        int level = 0;
        ASTNode currentIterator = current;
        ASTNode currentIteratorPrevious = current;
        while (!currentIterator.equals((Object)root)) {
            currentIteratorPrevious = currentIterator;
            if ((currentIterator = currentIterator.getParent()) == null) {
                return level;
            }
            if (!this.isATypeDeclaration(current) && this.isATypeDeclaration(currentIterator)) {
                return 0;
            }
            if (currentIterator.getNodeType() != current.getNodeType()) continue;
            ++level;
            Statement stmt = ((IfStatement)currentIterator).getElseStatement();
            if (stmt == null || stmt.getNodeType() != 25 || !currentIteratorPrevious.equals((Object)stmt)) continue;
            --level;
        }
        return level;
    }

    private boolean isATypeDeclaration(ASTNode node) {
        return node.getNodeType() == 1 || node.getNodeType() == 55;
    }
}

