/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.j2se.designprinciples.complexity;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.text.CharacterIterator;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.WhileStatement;

public class RuleLongConditional
extends AbstractCodeReviewRule {
    private static final String DEPTHVARIABLE = "DEPTHVARIABLE";
    private int maxDepth;

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        try {
            this.maxDepth = NumberFormat.getNumberInstance().parse(this.getParameter(DEPTHVARIABLE).getValue()).intValue();
            List list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 25);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.findMatchExpression(history.getHistoryId(), resource, ((IfStatement)it.next()).getExpression());
            }
            list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 61);
            it = list.iterator();
            while (it.hasNext()) {
                this.findMatchExpression(history.getHistoryId(), resource, ((WhileStatement)it.next()).getExpression());
            }
            list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 19);
            it = list.iterator();
            while (it.hasNext()) {
                this.findMatchExpression(history.getHistoryId(), resource, ((DoStatement)it.next()).getExpression());
            }
            list = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 24);
            it = list.iterator();
            while (it.hasNext()) {
                this.findMatchExpression(history.getHistoryId(), resource, ((ForStatement)it.next()).getExpression());
            }
        }
        catch (ParseException e) {
            Log.severe((String)"", (Throwable)e);
        }
    }

    private void findMatchExpression(String historyId, CodeReviewResource resource, Expression exp) {
        int iCtr;
        if (exp != null && (iCtr = this.countConditionalAndOrOrInfixOperator(exp.toString(), 0, InfixExpression.Operator.CONDITIONAL_AND.toString()) + this.countConditionalAndOrOrInfixOperator(exp.toString(), 0, InfixExpression.Operator.CONDITIONAL_OR.toString())) >= this.maxDepth) {
            resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)exp);
        }
    }

    private int countConditionalAndOrOrInfixOperator(String exp, int count, String operator) {
        RuleBasedCollator collator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        collator.setStrength(0);
        StringSearch search = new StringSearch(String.valueOf(operator), (CharacterIterator)new StringCharacterIterator(exp), collator);
        int index = search.first();
        int countedNumber = count;
        if (index != -1) {
            return this.countConditionalAndOrOrInfixOperator(exp.substring(index + 2), ++countedNumber, operator);
        }
        return countedNumber;
    }
}

