/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.translation.util;

import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class GlobalizationQuickFix
extends JavaCodeReviewQuickFix {
    public abstract TextEdit fixCodeReviewResult(ASTNode var1, IDocument var2);

    public final ASTNode getParent(ASTNode node, int nodeType) {
        ASTNode beginNode = node;
        while (beginNode != null) {
            if (beginNode.getNodeType() == nodeType) {
                return beginNode;
            }
            beginNode = beginNode.getParent();
        }
        return null;
    }

    public final Block getBlock(ASTNode beginNode) {
        ASTNode node = this.getParent(beginNode, 8);
        return node != null ? (Block)node : null;
    }

    public final String getUniqueIdentifierName(ICompilationUnit cpUnit, ASTNode node, String qualifiedTypeName) {
        return NamingConventions.suggestLocalVariableNames((IJavaProject)cpUnit.getJavaProject(), (String)this.getPackageName(qualifiedTypeName), (String)qualifiedTypeName, (int)0, (String[])this.getVarFromCurrentScope(node))[0];
    }

    protected final String[] getVarFromCurrentScope(ASTNode beginNode) {
        LinkedList variables = new LinkedList();
        this.collectVarDeclaration(variables, beginNode.getParent(), beginNode);
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(beginNode);
        if (typeDeclaration != null) {
            FieldDeclaration[] fields = typeDeclaration.getFields();
            int i = 0;
            while (i < fields.length) {
                this.addVarDecl(variables, fields[i].fragments());
                ++i;
            }
        }
        return variables.toArray(new String[variables.size()]);
    }

    protected final void collectVarDeclaration(final List variables, ASTNode parentNode, ASTNode currentNode) {
        if (parentNode == null) {
            return;
        }
        switch (parentNode.getNodeType()) {
            case 8: {
                Block block = (Block)parentNode;
                for (ASTNode statement : block.statements()) {
                    statement.accept(new ASTVisitor(){

                        public boolean visit(VariableDeclarationFragment node) {
                            variables.add(node.getName().getIdentifier());
                            return super.visit(node);
                        }
                    });
                }
                this.collectVarDeclaration(variables, parentNode.getParent(), parentNode);
                break;
            }
            case 24: {
                ForStatement forStatement = (ForStatement)parentNode;
                for (ASTNode node : forStatement.initializers()) {
                    if (node.getNodeType() != 58) break;
                    this.addVarDecl(variables, ((VariableDeclarationExpression)node).fragments());
                }
                this.collectVarDeclaration(variables, parentNode.getParent(), parentNode);
                break;
            }
            case 31: {
                MethodDeclaration methodDeclaration = (MethodDeclaration)parentNode;
                for (SingleVariableDeclaration element : methodDeclaration.parameters()) {
                    variables.add(element.getName().getIdentifier());
                }
                break;
            }
            default: {
                this.collectVarDeclaration(variables, parentNode.getParent(), parentNode);
            }
        }
    }

    protected final void addVarDecl(List variables, List fragments) {
        Iterator iter = fragments.iterator();
        while (iter.hasNext()) {
            variables.add(((VariableDeclarationFragment)iter.next()).getName().getIdentifier());
        }
    }

    protected final TypeDeclaration getTypeDeclaration(ASTNode beginNode) {
        ASTNode node = this.getParent(beginNode, 55);
        return node != null ? (TypeDeclaration)node : null;
    }

    protected final String getPackageName(String typeQualifiedName) {
        int index = typeQualifiedName.lastIndexOf(46);
        return index != -1 ? typeQualifiedName.substring(0, index) : "";
    }
}

