/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.translation;

import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import com.ibm.xtools.analysis.codereview.java.globalization.translation.util.NLSUtil;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;

public class StringPlusRule
extends AbstractCodeReviewRule {
    private static final String STRING_CLASS = "java.lang.String";
    private static final String PLUS_OPERATOR = "+";
    private static final String PLUS_EQUALS_OPERATOR = "+=";

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        String historyId = history.getHistoryId();
        CompilationUnit cu = resource.getResourceCompUnit();
        List ies = resource.getTypedNodeList((ASTNode)cu, 27);
        for (InfixExpression ie : ies) {
            ITypeBinding rightBinding;
            ITypeBinding leftBinding;
            if (!PLUS_OPERATOR.equals(ie.getOperator().toString()) || (leftBinding = ie.getLeftOperand().resolveTypeBinding()) == null || (rightBinding = ie.getRightOperand().resolveTypeBinding()) == null || !STRING_CLASS.equals(leftBinding.getQualifiedName()) && !STRING_CLASS.equals(rightBinding.getQualifiedName()) || NLSUtil.doesNodeHaveNonNLSComment(resource.getICompilationUnit(), (ASTNode)ie)) continue;
            resource.generateResultsForASTNode((AbstractAnalysisRule)this, history.getHistoryId(), (ASTNode)ie);
        }
        List as = resource.getTypedNodeList((ASTNode)cu, 7);
        for (Assignment a : as) {
            ITypeBinding leftBinding;
            if (!PLUS_EQUALS_OPERATOR.equals(a.getOperator().toString()) || (leftBinding = a.getLeftHandSide().resolveTypeBinding()) == null || !STRING_CLASS.equals(leftBinding.getQualifiedName()) || NLSUtil.doesNodeHaveNonNLSComment(resource.getICompilationUnit(), (ASTNode)a)) continue;
            resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)a);
        }
    }
}

