/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringTokenizerQuickFix
extends JavaCodeReviewQuickFix {
    public static final String IMPORT_IBM_STRINGTOKENIZER = "com.ibm.icu.util.StringTokenizer";
    public static final String IMPORT_JAVA_STRINGTOKENIZER = "java.util.StringTokenizer";
    public static final String STRINGTOKENIZER = "StringTokenizer";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private SimpleType st = null;
    private ClassInstanceCreation cic = null;
    private VariableDeclaration vd = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        ASTNode parentOfSn;
        if (theNode instanceof SimpleType) {
            this.st = (SimpleType)theNode;
        } else if (theNode instanceof ClassInstanceCreation) {
            this.cic = (ClassInstanceCreation)theNode;
        } else if (theNode instanceof SimpleName && ((parentOfSn = theNode.getParent()) instanceof VariableDeclarationFragment || parentOfSn instanceof SingleVariableDeclaration)) {
            this.vd = (VariableDeclaration)parentOfSn;
        }
        if (this.st != null || this.cic != null || this.vd != null) {
            SimpleName newType;
            ASTNode enclosingClass = null;
            CompilationUnit rootNode = null;
            if (this.st != null) {
                enclosingClass = this.getEnclosingClass((ASTNode)this.st);
                rootNode = (CompilationUnit)this.st.getRoot();
            } else if (this.cic != null) {
                enclosingClass = this.getEnclosingClass((ASTNode)this.cic);
                rootNode = (CompilationUnit)this.cic.getRoot();
            } else if (this.vd != null) {
                enclosingClass = this.getEnclosingClass((ASTNode)this.vd);
                rootNode = (CompilationUnit)this.vd.getRoot();
            }
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean replaced = false;
            for (ImportDeclaration ip : imports) {
                if (Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT_IBM_STRINGTOKENIZER)) {
                    replaced = true;
                    break;
                }
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT_JAVA_STRINGTOKENIZER)) continue;
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)IMPORT_IBM_STRINGTOKENIZER);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.replace((ASTNode)ip, newImport, null);
                replaced = true;
                break;
            }
            if (!replaced) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)IMPORT_IBM_STRINGTOKENIZER);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            if (this.st != null) {
                if (Collator.getInstance().equals(this.st.toString(), IMPORT_JAVA_STRINGTOKENIZER)) {
                    SimpleName newType2 = ast.newSimpleName(STRINGTOKENIZER);
                    SimpleType newSimpleType = ast.newSimpleType((Name)newType2);
                    rewriter.replace((ASTNode)this.st, (ASTNode)newSimpleType, null);
                }
            } else if (this.cic != null) {
                ClassInstanceCreation newCic = ast.newClassInstanceCreation();
                List args = this.cic.arguments();
                newType = ast.newSimpleName(STRINGTOKENIZER);
                newCic.setType((Type)ast.newSimpleType((Name)newType));
                Iterator it = args.iterator();
                while (it.hasNext()) {
                    ASTNode node = rewriter.createCopyTarget((ASTNode)it.next());
                    newCic.arguments().add(node);
                }
                rewriter.replace((ASTNode)this.cic, (ASTNode)newCic, null);
            } else if (this.vd != null) {
                if (this.vd instanceof SingleVariableDeclaration) {
                    SingleVariableDeclaration svd = (SingleVariableDeclaration)this.vd;
                    Type theType = svd.getType();
                    if (Collator.getInstance().equals(theType.toString(), IMPORT_JAVA_STRINGTOKENIZER)) {
                        newType = ast.newSimpleName(STRINGTOKENIZER);
                        SimpleType newSimpleType = ast.newSimpleType((Name)newType);
                        rewriter.replace((ASTNode)theType, (ASTNode)newSimpleType, null);
                    }
                } else if (this.vd instanceof VariableDeclarationFragment) {
                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)this.vd;
                    ASTNode parentOfVdf = vdf.getParent();
                    Type theType = null;
                    if (parentOfVdf instanceof VariableDeclarationStatement) {
                        VariableDeclarationStatement vds = (VariableDeclarationStatement)parentOfVdf;
                        theType = vds.getType();
                    } else if (parentOfVdf instanceof FieldDeclaration) {
                        FieldDeclaration fd = (FieldDeclaration)parentOfVdf;
                        theType = fd.getType();
                    } else if (parentOfVdf instanceof VariableDeclarationExpression) {
                        VariableDeclarationExpression vde = (VariableDeclarationExpression)parentOfVdf;
                        theType = vde.getType();
                    }
                    if (theType != null) {
                        SimpleName newType3 = ast.newSimpleName(STRINGTOKENIZER);
                        SimpleType newSimpleType = ast.newSimpleType((Name)newType3);
                        rewriter.replace((ASTNode)theType, (ASTNode)newSimpleType, null);
                    } else {
                        return null;
                    }
                }
            }
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }
}

