/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.xtools.analysis.codereview.java.globalization.translation.util.GlobalizationQuickFix;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringEqualsQuickFix
extends GlobalizationQuickFix {
    public static final String IMPORT_COLLATOR = "com.ibm.icu.text.Collator";
    public static final String CLASS_COLLATOR = "Collator";
    public static final String EQUALSIGNORECASE = "equalsIgnoreCase";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String FIX1 = "final Collator %1% = Collator.getInstance();";
    private static final String FIX2 = "%1%.setStrength( Collator.SECONDARY );";
    private static final String FIX3 = "%1%.equals( %2%, %3% )";
    private static final String FIX4 = "Collator.getInstance().equals( %1%, %2% )";
    private static final String TAG_1 = "%1%";
    private static final String TAG_2 = "%2%";
    private static final String TAG_3 = "%3%";

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        MethodInvocation mi = (MethodInvocation)theNode;
        if (mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT_COLLATOR)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)IMPORT_COLLATOR);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            String arg1 = mi.getExpression().toString();
            String arg2 = mi.arguments().get(0).toString();
            ASTNode replaceNode = null;
            if (Collator.getInstance().equals(mi.getName().getIdentifier(), EQUALSIGNORECASE)) {
                String varName = this.getUniqueIdentifierName(super.getWorkingCompilationUnit(), (ASTNode)mi, IMPORT_COLLATOR);
                String line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)varName);
                ASTNode collatorNode = rewriter.createStringPlaceholder(line, 60);
                this.insertCollator(mi, rewriter, collatorNode);
                line = AnalysisCorePlugin.replace((String)FIX2, (String)TAG_1, (String)varName);
                ASTNode collatorNode2 = rewriter.createStringPlaceholder(line, 32);
                this.insertCollator(mi, rewriter, collatorNode2);
                line = AnalysisCorePlugin.replace((String)FIX3, (String)TAG_1, (String)varName);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)arg1);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG_3, (String)arg2);
                replaceNode = rewriter.createStringPlaceholder(line, 32);
            } else {
                String line = AnalysisCorePlugin.replace((String)FIX4, (String)TAG_1, (String)arg1);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)arg2);
                replaceNode = rewriter.createStringPlaceholder(line, 32);
            }
            rewriter.replace((ASTNode)mi, replaceNode, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private ASTNode getNodeBetween(ASTNode beginNode, ASTNode endNode, int nodeTypeToFind) {
        ASTNode node = beginNode;
        while (node != null && node.equals((Object)endNode)) {
            if (node.getNodeType() == nodeTypeToFind) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private Statement getFirstEnclosingStatement(ASTNode node) {
        ASTNode beginNode = node;
        while (beginNode != null && beginNode.getNodeType() != 31 && beginNode.getNodeType() != 55 && beginNode.getNodeType() != 1) {
            if (beginNode instanceof Statement) {
                return (Statement)beginNode;
            }
            beginNode = beginNode.getParent();
        }
        return null;
    }

    private void processInsertWithLabel(ASTRewrite r, ListRewrite l, Block block, LabeledStatement labeledStatement) {
        ASTNode placeHolderNode = r.createMoveTarget((ASTNode)labeledStatement.getBody());
        l.insertAfter(placeHolderNode, (ASTNode)labeledStatement, null);
    }

    private void insertCollator(MethodInvocation m, ASTRewrite r, ASTNode collatorNode) {
        Block block = this.getBlock((ASTNode)m);
        if (block != null) {
            ASTNode node = this.getNodeBetween((ASTNode)m, (ASTNode)block, 30);
            ListRewrite l = r.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            if (node != null) {
                this.processInsertWithLabel(r, l, block, (LabeledStatement)node);
            } else {
                Statement ref = this.getFirstEnclosingStatement((ASTNode)m);
                l.insertBefore(collatorNode, (ASTNode)ref, null);
            }
        }
    }
}

