/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.xtools.analysis.codereview.java.globalization.translation.util.GlobalizationQuickFix;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringCompareToQuickFix
extends GlobalizationQuickFix {
    public static final String IMPORT_STRING_COMPARATOR = "com.ibm.icu.text.UTF16.StringComparator";
    public static final String IMPORT_COLLATOR = "com.ibm.icu.text.Collator";
    public static final String CLASS_COLLATOR = "Collator";
    public static final String CLASS_STRING_COMPARATOR = "StringComparator";
    private static final String FIX1 = "final StringComparator %1% = new StringComparator(true, %2%, StringComparator.FOLD_CASE_DEFAULT);";
    private static final String FIX2 = "%1%.compare( %2%, %3% )";
    private static final String FIX3 = "Collator.getInstance().compare( %1%, %2% )";
    private static final String TAG1 = "%1%";
    private static final String TAG2 = "%2%";
    private static final String TAG3 = "%3%";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String COMPARE_IGNORE = "compareToIgnoreCase";
    private String theImport = null;
    private String theClass = null;
    private String equalsIgnoreCase = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        MethodInvocation mi = (MethodInvocation)theNode;
        if (mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), this.theImport)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)this.theImport);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            String varName = "";
            if (Collator.getInstance().equals(this.theClass, CLASS_STRING_COMPARATOR)) {
                this.equalsIgnoreCase = Collator.getInstance().equals(mi.getName().getIdentifier(), COMPARE_IGNORE) ? TRUE : FALSE;
                varName = this.getUniqueIdentifierName(super.getWorkingCompilationUnit(), (ASTNode)mi, IMPORT_STRING_COMPARATOR);
                String line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG1, (String)varName);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG2, (String)this.equalsIgnoreCase);
                ASTNode comparatorNode = rewriter.createStringPlaceholder(line, 60);
                this.insertComparator(mi, rewriter, comparatorNode);
            }
            String arg1 = mi.getExpression().toString();
            String arg2 = mi.arguments().get(0).toString();
            ASTNode replaceNode = null;
            String line1 = AnalysisCorePlugin.replace((String)FIX2, (String)TAG1, (String)varName);
            line1 = AnalysisCorePlugin.replace((String)line1, (String)TAG2, (String)arg1);
            line1 = AnalysisCorePlugin.replace((String)line1, (String)TAG3, (String)arg2);
            String line2 = AnalysisCorePlugin.replace((String)FIX3, (String)TAG1, (String)arg1);
            line2 = AnalysisCorePlugin.replace((String)line2, (String)TAG2, (String)arg2);
            replaceNode = Collator.getInstance().equals(this.theClass, CLASS_STRING_COMPARATOR) ? rewriter.createStringPlaceholder(line1, 32) : rewriter.createStringPlaceholder(line2, 32);
            rewriter.replace((ASTNode)mi, replaceNode, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private ASTNode getNodeBetween(ASTNode beginNode, ASTNode endNode, int nodeTypeToFind) {
        ASTNode node = beginNode;
        while (node != null && node.equals((Object)endNode)) {
            if (node.getNodeType() == nodeTypeToFind) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private Statement getFirstEnclosingStatement(ASTNode node) {
        ASTNode beginNode = node;
        while (beginNode != null && beginNode.getNodeType() != 31 && beginNode.getNodeType() != 55 && beginNode.getNodeType() != 1) {
            if (beginNode instanceof Statement) {
                return (Statement)beginNode;
            }
            beginNode = beginNode.getParent();
        }
        return null;
    }

    private void processInsertWithLabel(ASTRewrite r, ListRewrite l, Block block, LabeledStatement labeledStatement) {
        ASTNode placeHolderNode = r.createMoveTarget((ASTNode)labeledStatement.getBody());
        l.insertAfter(placeHolderNode, (ASTNode)labeledStatement, null);
    }

    private void insertComparator(MethodInvocation m, ASTRewrite r, ASTNode comparatorNode) {
        Block block = this.getBlock((ASTNode)m);
        if (block != null) {
            ASTNode node = this.getNodeBetween((ASTNode)m, (ASTNode)block, 30);
            ListRewrite l = r.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            if (node != null) {
                this.processInsertWithLabel(r, l, block, (LabeledStatement)node);
            } else {
                Statement ref = this.getFirstEnclosingStatement((ASTNode)m);
                l.insertBefore(comparatorNode, (ASTNode)ref, null);
            }
        }
    }

    public String getEqualsIgnoreCase() {
        return this.equalsIgnoreCase;
    }

    public void setEqualsIgnoreCase(String equalsIgnoreCase) {
        this.equalsIgnoreCase = equalsIgnoreCase;
    }

    public String getTheImport() {
        return this.theImport;
    }

    public void setTheImport(String theImport) {
        this.theImport = theImport;
    }

    public String getTheClass() {
        return this.theClass;
    }

    public void setTheClass(String theClass) {
        this.theClass = theClass;
    }
}

