/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.xtools.analysis.codereview.java.globalization.stringhandling.quickfix.CharSetDialog;
import com.ibm.xtools.analysis.codereview.java.globalization.translation.util.GlobalizationQuickFix;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StringByteConstructorQuickFix1
extends GlobalizationQuickFix {
    public static final String IMPORT1 = "java.nio.ByteBuffer";
    public static final String IMPORT2 = "java.nio.charset.Charset";
    public static final String IMPORT3 = "java.nio.charset.CharsetDecoder";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String DECODER = "final CharsetDecoder %variable% = Charset.forName( \"%charset%\" ).newDecoder();";
    private static final String DECODER2 = "%variable%.decode(ByteBuffer.wrap( %charset%\" ) ).toString();";
    private static final String VARIABLE_TAG = "%variable%";
    private static final String CHARSET_TAG = "%charset%";
    private String theCharSet = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        ClassInstanceCreation cic = (ClassInstanceCreation)theNode;
        if (cic != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)cic);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CharSetDialog dg = new CharSetDialog(Display.getDefault().getActiveShell());
            dg.create();
            if (dg.open() == 0 && (this.theCharSet = dg.getTheCharSet()) != null) {
                ASTNode newImport;
                String line;
                CompilationUnit rootNode = (CompilationUnit)cic.getRoot();
                ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
                ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
                List imports = rootNode.imports();
                boolean hasByteBuffer = false;
                boolean hasCharset = false;
                boolean hasCharsetDecoder = false;
                for (ImportDeclaration ip : imports) {
                    if (!hasByteBuffer && Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT1)) {
                        hasByteBuffer = true;
                    }
                    if (!hasCharset && Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT2)) {
                        hasCharset = true;
                    }
                    if (!hasCharsetDecoder && Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), IMPORT3)) {
                        hasCharsetDecoder = true;
                    }
                    if (hasByteBuffer && hasCharset && hasCharsetDecoder) break;
                }
                if (!hasByteBuffer) {
                    line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)IMPORT1);
                    newImport = rewriter.createStringPlaceholder(line, 26);
                    lr.insertLast(newImport, null);
                }
                if (!hasCharset) {
                    line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)IMPORT2);
                    newImport = rewriter.createStringPlaceholder(line, 26);
                    lr.insertLast(newImport, null);
                }
                if (!hasCharsetDecoder) {
                    line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)IMPORT3);
                    newImport = rewriter.createStringPlaceholder(line, 26);
                    lr.insertLast(newImport, null);
                }
                String varName = this.getUniqueIdentifierName(super.getWorkingCompilationUnit(), (ASTNode)cic, IMPORT3);
                String line2 = AnalysisCorePlugin.replace((String)DECODER, (String)VARIABLE_TAG, (String)varName);
                line2 = AnalysisCorePlugin.replace((String)line2, (String)CHARSET_TAG, (String)this.theCharSet);
                ASTNode newStatement = rewriter.createStringPlaceholder(line2, 60);
                this.insertDecoder(cic, rewriter, newStatement);
                String argument = cic.arguments().get(0).toString();
                line2 = AnalysisCorePlugin.replace((String)DECODER2, (String)VARIABLE_TAG, (String)varName);
                line2 = AnalysisCorePlugin.replace((String)line2, (String)CHARSET_TAG, (String)argument);
                ASTNode newMi = rewriter.createStringPlaceholder(line2, 32);
                rewriter.replace((ASTNode)cic, newMi, null);
                MultiTextEdit edits = new MultiTextEdit();
                edits.addChild(rewriter.rewriteAST(docToChange, null));
                return edits;
            }
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private ASTNode getNodeBetween(ASTNode beginNode, ASTNode endNode, int nodeTypeToFind) {
        ASTNode node = beginNode;
        while (node != null && !node.equals((Object)endNode)) {
            if (node.getNodeType() == nodeTypeToFind) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private Statement getFirstEnclosingStatement(ASTNode node) {
        ASTNode beginNode = node;
        while (beginNode != null && beginNode.getNodeType() != 31 && beginNode.getNodeType() != 55 && beginNode.getNodeType() != 1) {
            if (beginNode instanceof Statement) {
                return (Statement)beginNode;
            }
            beginNode = beginNode.getParent();
        }
        return null;
    }

    private void processInsertWithLabel(ASTRewrite r, ListRewrite l, Block block, LabeledStatement labeledStatement) {
        ASTNode placeHolderNode = r.createMoveTarget((ASTNode)labeledStatement.getBody());
        l.insertAfter(placeHolderNode, (ASTNode)labeledStatement, null);
    }

    private void insertDecoder(ClassInstanceCreation c, ASTRewrite r, ASTNode decoderNode) {
        Block block = this.getBlock((ASTNode)c);
        if (block != null) {
            ASTNode node = this.getNodeBetween((ASTNode)c, (ASTNode)block, 30);
            ListRewrite l = r.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
            if (node != null) {
                this.processInsertWithLabel(r, l, block, (LabeledStatement)node);
            } else {
                Statement ref = this.getFirstEnclosingStatement((ASTNode)c);
                l.insertBefore(decoderNode, (ASTNode)ref, null);
            }
        }
    }
}

