/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling;

import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.DeclaringClassRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.MethodNameRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ParameterCountRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class StringValueOfRule
extends AbstractCodeReviewRule {
    private static final String STRING_CLASS = "java.lang.String";
    private static final String VALUE_OF_METHOD = "valueOf";
    private static final String INT_PRIMITIVE = "int";
    private static final String DOUBLE_PRIMITIVE = "double";
    private static final String FLOAT_PRIMITIVE = "float";
    private static final String LONG_PRIMITIVE = "long";
    private static final String[] PRIMITIVES = new String[]{"int", "double", "float", "long"};
    private static final IRuleFilter[] miFilters = new IRuleFilter[]{new DeclaringClassRuleFilter("java.lang.String", true), new MethodNameRuleFilter("valueOf", true), new ParameterCountRuleFilter(1, true)};

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        String historyId = history.getHistoryId();
        List mis = resource.getTypedNodeList((ASTNode)resource.getResourceCompUnit(), 32);
        ASTHelper.satisfy((List)mis, (IRuleFilter[])miFilters);
        block0: for (MethodInvocation mi : mis) {
            IMethodBinding methodBinding = mi.resolveMethodBinding();
            if (methodBinding == null) continue;
            String type = methodBinding.getParameterTypes()[0].getQualifiedName();
            int j = 0;
            while (j < PRIMITIVES.length) {
                if (PRIMITIVES[j].equals(type)) {
                    resource.generateResultsForASTNode((AbstractAnalysisRule)this, historyId, (ASTNode)mi);
                    continue block0;
                }
                ++j;
            }
        }
    }
}

