/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.stringhandling;

import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;

public class CharComparisonRule
extends AbstractCodeReviewRule {
    private static final String OP_EQUALS = "==";
    private static final String OP_NOTEQUALS = "!=";
    private static final String OP_LESSEQUALS = "<=";
    private static final String OP_GREATEREQUALS = ">=";
    private static final String OP_LESS = "<";
    private static final String OP_GREATER = ">";
    private static final String CHAR_PRIMITIVE = "char";

    public void analyze(AnalysisHistory history, final CodeReviewResource resource) {
        final String historyId = history.getHistoryId();
        resource.getResourceCompUnit().accept(new ASTVisitor(){

            public boolean visit(InfixExpression node) {
                ITypeBinding rightBinding;
                String operator = node.getOperator().toString();
                ITypeBinding leftBinding = node.getLeftOperand().resolveTypeBinding();
                if (leftBinding != null && (rightBinding = node.getRightOperand().resolveTypeBinding()) != null && (CharComparisonRule.OP_EQUALS.equals(operator) || CharComparisonRule.OP_NOTEQUALS.equals(operator) || CharComparisonRule.OP_LESSEQUALS.equals(operator) || CharComparisonRule.OP_GREATEREQUALS.equals(operator) || CharComparisonRule.OP_LESS.equals(operator) || CharComparisonRule.OP_GREATER.equals(operator)) && CharComparisonRule.CHAR_PRIMITIVE.equals(leftBinding.getName()) && CharComparisonRule.CHAR_PRIMITIVE.equals(rightBinding.getName())) {
                    resource.generateResultsForASTNode((AbstractAnalysisRule)CharComparisonRule.this, historyId, (ASTNode)node);
                }
                return true;
            }
        });
    }
}

