/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.encoding.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import com.ibm.xtools.analysis.codereview.java.globalization.encoding.quickfix.CharSetDialog;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class OutputStreamReaderQuickFix
extends JavaCodeReviewQuickFix {
    private static final String CHARSET = "java.nio.charset.Charset";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String CHARSET_LINE = "Charset.forName( \"%charset%\" ).newEncoder()";
    private static final String CHARSET_TAG = "%charset%";
    private String theCharSet = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        ClassInstanceCreation cic = (ClassInstanceCreation)theNode;
        if (cic != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)cic);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CharSetDialog dg = new CharSetDialog(Display.getDefault().getActiveShell());
            dg.create();
            if (dg.open() == 0 && (this.theCharSet = dg.getTheCharSet()) != null) {
                CompilationUnit rootNode = (CompilationUnit)cic.getRoot();
                ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
                ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
                List imports = rootNode.imports();
                boolean addImport = true;
                String theImport = CHARSET;
                for (ImportDeclaration ip : imports) {
                    if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), theImport)) continue;
                    addImport = false;
                    break;
                }
                if (addImport) {
                    String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)theImport);
                    ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                    lr.insertLast(newImport, null);
                }
                ListRewrite lr2 = rewriter.getListRewrite((ASTNode)cic, ClassInstanceCreation.ARGUMENTS_PROPERTY);
                String line = AnalysisCorePlugin.replace((String)CHARSET_LINE, (String)CHARSET_TAG, (String)this.theCharSet);
                ASTNode newArg = rewriter.createStringPlaceholder(line, 32);
                lr2.insertLast(newArg, null);
                MultiTextEdit edits = new MultiTextEdit();
                edits.addChild(rewriter.rewriteAST(docToChange, null));
                return edits;
            }
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }
}

