/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.culturalformatting.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ToStringQuickFix
extends JavaCodeReviewQuickFix {
    public static final String IMPORT_IBM_ICU_NUMBER_FORMAT = "com.ibm.icu.text.NumberFormat";
    public static final String IMPORT_JAVA_TEXT_NUMBER_FORMAT = "java.text.NumberFormat";
    public static final String IMPORT_IBM_ICU_DATE_FORMAT = "com.ibm.icu.text.DateFormat";
    public static final String IMPORT_JAVA_TEXT_DATE_FORMAT = "java.text.DateFormat";
    private static final String DATEFORMAT = "DateFormat";
    private static final String NUMBERFORMAT = "NumberFormat";
    private static final String DATEINSTANCE = "getDateInstance()";
    private static final String NUMBERINSTANCE = "getNumberInstance()";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String FIX1 = "%1%.%2%.format( %3% )";
    private static final String FIX2 = "String.valueOf( %1%.%2%.format( %3% ) )";
    private static final String TAG_1 = "%1%";
    private static final String TAG_2 = "%2%";
    private static final String TAG_3 = "%3%";
    public static final String BIG_DECIMAL = "java.math.BigDecimal";
    public static final String BIG_INTEGER = "java.math.BigInteger";
    public static final String DATE = "java.util.Date";
    public static final String SQL_TIME = "java.sql.Time";
    public static final String BYTE = "java.lang.Byte";
    public static final String STRING = "java.lang.String";
    public static final String DOUBLE = "java.lang.Double";
    public static final String INTEGER = "java.lang.Integer";
    public static final String FLOAT = "java.lang.Float";
    public static final String LONG = "java.lang.Long";
    public static final String SHORT = "java.lang.Short";
    public static final String TO_STRING = "toString";
    public static final String VALUE_OF = "valueOf";
    public static final String BYTE_PRIMITIVE = "byte";
    public static final String FLOAT_PRIMITIVE = "float";
    public static final String DOUBLE_PRIMITIVE = "double";
    public static final String INT_PRIMITIVE = "int";
    public static final String LONG_PRIMITIVE = "long";
    public static final String SHORT_PRIMITIVE = "short";
    private String theClass = null;
    private String theImport = null;
    private String thePrimitive = null;
    private String argument = null;
    private MethodInvocation mi = null;

    public TextEdit fixCodeReviewResult(ASTNode theNode, IDocument docToChange) {
        this.mi = null;
        if (theNode instanceof MethodInvocation) {
            this.mi = (MethodInvocation)theNode;
        }
        if (this.mi != null) {
            String methodName;
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)this.mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)this.mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), this.theImport)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)this.theImport);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            ASTNode replaceNode = null;
            String clazz = Collator.getInstance().equals(this.theClass, DATE) || Collator.getInstance().equals(this.theClass, SQL_TIME) ? DATEFORMAT : NUMBERFORMAT;
            String string = methodName = Collator.getInstance().equals(this.theClass, DATE) || Collator.getInstance().equals(SQL_TIME, this.theClass) ? DATEINSTANCE : NUMBERINSTANCE;
            if (Collator.getInstance().equals(TO_STRING, this.mi.getName().getIdentifier())) {
                IMethodBinding methodBinding = this.mi.resolveMethodBinding();
                if (methodBinding != null) {
                    Expression expression;
                    ITypeBinding typeBinding;
                    if (methodBinding.getParameterTypes().length == 0) {
                        this.argument = this.mi.getExpression().toString();
                    }
                    if (this.thePrimitive != null && methodBinding.getParameterTypes().length == 1 && (typeBinding = (expression = (Expression)this.mi.arguments().get(0)).resolveTypeBinding()) != null && Collator.getInstance().equals(typeBinding.getQualifiedName(), this.thePrimitive)) {
                        this.argument = expression.toString();
                    }
                    String line = AnalysisCorePlugin.replace((String)FIX1, (String)TAG_1, (String)clazz);
                    line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)methodName);
                    line = AnalysisCorePlugin.replace((String)line, (String)TAG_3, (String)this.argument);
                    replaceNode = rewriter.createStringPlaceholder(line, 32);
                    rewriter.replace((ASTNode)this.mi, replaceNode, null);
                }
            } else if (Collator.getInstance().equals(VALUE_OF, this.mi.getName().getIdentifier())) {
                this.argument = ((Expression)this.mi.arguments().get(0)).toString();
                String line = AnalysisCorePlugin.replace((String)FIX2, (String)TAG_1, (String)clazz);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG_2, (String)methodName);
                line = AnalysisCorePlugin.replace((String)line, (String)TAG_3, (String)this.argument);
                replaceNode = rewriter.createStringPlaceholder(line, 32);
                rewriter.replace((ASTNode)this.mi, replaceNode, null);
            }
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    public String getTheClass() {
        return this.theClass;
    }

    public void setTheClass(String theClass) {
        this.theClass = theClass;
    }

    public String getTheImport() {
        return this.theImport;
    }

    public void setTheImport(String theImport) {
        this.theImport = theImport;
    }

    public String getThePrimitive() {
        return this.thePrimitive;
    }

    public void setThePrimitive(String thePrimitive) {
        this.thePrimitive = thePrimitive;
    }
}

