/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.culturalformatting.quickfix;

import com.ibm.icu.text.Collator;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.quickfix.JavaCodeReviewQuickFix;
import com.ibm.rsaz.analysis.core.AnalysisCorePlugin;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class ParseQuickFix
extends JavaCodeReviewQuickFix {
    public static final String IMPORT_IBM_ICU_NUMBER_FORMAT = "com.ibm.icu.text.NumberFormat";
    public static final String IMPORT_JAVA_TEXT_NUMBER_FORMAT = "java.text.NumberFormat";
    private static final String IMPORT = "import %imp%;";
    private static final String IMPORT_TAG = "%imp%";
    private static final String NUMBER_FORMAT = "NumberFormat.getNumberInstance().parse( %number% ).%method%";
    private static final String NUMBER_TAG = "%number%";
    private static final String METHOD_TAG = "%method%";
    public static final String STRING = "java.lang.String";
    public static final String BYTE = "java.lang.Byte";
    public static final String DOUBLE = "java.lang.Double";
    public static final String INTEGER = "java.lang.Integer";
    public static final String FLOAT = "java.lang.Float";
    public static final String LONG = "java.lang.Long";
    public static final String SHORT = "java.lang.Short";
    public static final String BYTE_PRIMITIVE = "byte";
    public static final String FLOAT_PRIMITIVE = "float";
    public static final String DOUBLE_PRIMITIVE = "double";
    public static final String INT_PRIMITIVE = "int";
    public static final String LONG_PRIMITIVE = "long";
    public static final String SHORT_PRIMITIVE = "short";
    public static final String OLD_BYTE_METHOD = "parseByte";
    public static final String OLD_DOUBLE_METHOD = "parseDouble";
    public static final String OLD_FLOAT_METHOD = "parseFloat";
    public static final String OLD_INT_METHOD = "parseInt";
    public static final String OLD_LONG_METHOD = "parseLong";
    public static final String OLD_SHORT_METHOD = "parseShort";
    public static final String BYTE_VALUE_METHOD = "byteValue()";
    public static final String DOUBLE_VALUE_METHOD = "doubleValue()";
    public static final String FLOAT_VALUE_METHOD = "floatValue()";
    public static final String INT_VALUE_METHOD = "intValue()";
    public static final String LONG_VALUE_METHOD = "longValue()";
    public static final String SHORT_VALUE_METHOD = "shortValue()";
    private String theClass = null;
    private String theImport = null;
    private String thePrimitive = null;
    private String methodName = null;
    private String theNewMethod = null;
    private String argument = null;

    public TextEdit fixCodeReviewResult(ASTNode node, IDocument docToChange) {
        ASTNode theNode = node.getParent();
        MethodInvocation mi = this.getMethodInvocation(theNode);
        if (mi != null) {
            ASTNode enclosingClass = this.getEnclosingClass((ASTNode)mi);
            AST ast = enclosingClass.getAST();
            ASTRewrite rewriter = ASTRewrite.create((AST)ast);
            CompilationUnit rootNode = (CompilationUnit)mi.getRoot();
            ChildListPropertyDescriptor descriptor = CompilationUnit.IMPORTS_PROPERTY;
            ListRewrite lr = rewriter.getListRewrite((ASTNode)rootNode, descriptor);
            List imports = rootNode.imports();
            boolean addImport = true;
            for (ImportDeclaration ip : imports) {
                if (!Collator.getInstance().equals(ip.getName().getFullyQualifiedName(), this.theImport)) continue;
                addImport = false;
                break;
            }
            if (addImport) {
                String line = AnalysisCorePlugin.replace((String)IMPORT, (String)IMPORT_TAG, (String)this.theImport);
                ASTNode newImport = rewriter.createStringPlaceholder(line, 26);
                lr.insertLast(newImport, null);
            }
            ASTNode toReplace = this.getMethodInvocationParse(mi);
            String line = AnalysisCorePlugin.replace((String)NUMBER_FORMAT, (String)NUMBER_TAG, (String)this.argument);
            line = AnalysisCorePlugin.replace((String)line, (String)METHOD_TAG, (String)this.theNewMethod);
            ASTNode replaceNode = rewriter.createStringPlaceholder(line, 32);
            rewriter.replace(toReplace, replaceNode, null);
            MultiTextEdit edits = new MultiTextEdit();
            edits.addChild(rewriter.rewriteAST(docToChange, null));
            return edits;
        }
        return null;
    }

    private ASTNode getEnclosingClass(ASTNode node) {
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 55 && currentNode.getNodeType() != 1) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    private MethodInvocation getMethodInvocation(ASTNode node) {
        if (node instanceof ExpressionStatement) {
            Expression exp = ASTHelper.removeParenthesis((Expression)((ExpressionStatement)node).getExpression());
            return exp != null && exp instanceof MethodInvocation ? (MethodInvocation)exp : null;
        }
        if (node instanceof ReturnStatement) {
            Expression exp = ASTHelper.removeParenthesis((Expression)((ReturnStatement)node).getExpression());
            return exp != null && exp instanceof MethodInvocation ? (MethodInvocation)exp : null;
        }
        if (node instanceof VariableDeclarationFragment) {
            Expression exp = ASTHelper.removeParenthesis((Expression)((VariableDeclarationFragment)node).getInitializer());
            return exp != null && exp instanceof MethodInvocation ? (MethodInvocation)exp : null;
        }
        if (node instanceof Assignment) {
            Expression exp = ASTHelper.removeParenthesis((Expression)((Assignment)node).getRightHandSide());
            return exp != null && exp instanceof MethodInvocation ? (MethodInvocation)exp : null;
        }
        ASTNode currentNode = node;
        while (currentNode != null && currentNode.getNodeType() != 32) {
            currentNode = currentNode.getParent();
        }
        return currentNode != null ? (MethodInvocation)currentNode : null;
    }

    private ASTNode getMethodInvocationParse(MethodInvocation node) {
        List expList = ASTHelper.getExpressionList((ASTNode)node, (boolean)true);
        for (ASTNode expNode : expList) {
            MethodInvocation expMi;
            IMethodBinding methodBinding;
            if (expNode.getNodeType() != 32 || (methodBinding = (expMi = (MethodInvocation)expNode).resolveMethodBinding()) == null || !Collator.getInstance().equals(methodBinding.getDeclaringClass().getQualifiedName(), this.theClass) || !Collator.getInstance().equals(methodBinding.getReturnType().getQualifiedName(), this.thePrimitive) || !Collator.getInstance().equals(expMi.getName().getIdentifier(), this.methodName) || methodBinding.getParameterTypes().length != 1) continue;
            ITypeBinding typeBinding0 = ((Expression)expMi.arguments().get(0)).resolveTypeBinding();
            if (!Collator.getInstance().equals(STRING, typeBinding0.getQualifiedName()) && (methodBinding.getParameterTypes().length != 2 || !Collator.getInstance().equals(typeBinding0.getQualifiedName(), STRING))) continue;
            if (expMi.arguments().size() == 1) {
                this.argument = ((Expression)expMi.arguments().get(0)).toString();
                return expMi;
            }
            ITypeBinding typeBinding1 = ((Expression)expMi.arguments().get(1)).resolveTypeBinding();
            if (!Collator.getInstance().equals(typeBinding1.getQualifiedName(), INT_PRIMITIVE)) continue;
            this.argument = ((Expression)expMi.arguments().get(0)).toString();
            return expMi;
        }
        return null;
    }

    public String getTheClass() {
        return this.theClass;
    }

    public void setTheClass(String theClass) {
        this.theClass = theClass;
    }

    public String getTheImport() {
        return this.theImport;
    }

    public void setTheImport(String theImport) {
        this.theImport = theImport;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getThePrimitive() {
        return this.thePrimitive;
    }

    public void setThePrimitive(String thePrimitive) {
        this.thePrimitive = thePrimitive;
    }

    public String getTheNewMethod() {
        return this.theNewMethod;
    }

    public void setTheNewMethod(String theNewMethod) {
        this.theNewMethod = theNewMethod;
    }
}

