/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.culturalformatting;

import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ArgumentTypeRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.DeclaringClassRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.MethodNameRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ParameterCountRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class PrimitiveToStringRule
extends AbstractCodeReviewRule {
    private static final String CLASS = "CLASS";
    private static final String PRIMITIVE = "PRIMITIVE";
    private static final String TO_STRING_METHOD = "toString";
    private static final String STRING_CLASS = "java.lang.String";
    private static final String VALUE_OF_METHOD = "valueOf";
    private static final DeclaringClassRuleFilter stringClassFilter = new DeclaringClassRuleFilter("java.lang.String", true);
    private static final MethodNameRuleFilter methodFilter = new MethodNameRuleFilter("toString", true);
    private static final MethodNameRuleFilter methodValueOfFilter = new MethodNameRuleFilter("valueOf", true);
    private static final ParameterCountRuleFilter paramCount0 = new ParameterCountRuleFilter(0, true);
    private static final ParameterCountRuleFilter paramCount1 = new ParameterCountRuleFilter(1, true);

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        String historyId = history.getHistoryId();
        CompilationUnit cu = resource.getResourceCompUnit();
        String className = this.getParameter(CLASS).getValue();
        String primitiveName = this.getParameter(PRIMITIVE).getValue();
        DeclaringClassRuleFilter classFilter = new DeclaringClassRuleFilter(className, true);
        IRuleFilter[] miFilters1 = new IRuleFilter[]{classFilter, methodFilter, paramCount0};
        List mis1 = resource.getTypedNodeList((ASTNode)cu, 32);
        ArrayList mis2 = new ArrayList(mis1);
        ASTHelper.satisfy((List)mis1, (IRuleFilter[])miFilters1);
        resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, (Collection)mis1);
        IRuleFilter[] miFilters2 = new IRuleFilter[]{classFilter, methodFilter, paramCount1, new ArgumentTypeRuleFilter(primitiveName, 0, true)};
        ASTHelper.satisfy(mis2, (IRuleFilter[])miFilters2);
        resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, mis2);
        IRuleFilter[] miFilters3 = new IRuleFilter[]{stringClassFilter, methodValueOfFilter, new ArgumentTypeRuleFilter(className, 0, true)};
        List mis3 = resource.getTypedNodeList((ASTNode)cu, 32);
        ASTHelper.satisfy((List)mis3, (IRuleFilter[])miFilters3);
        resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, (Collection)mis3);
    }
}

