/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.codereview.java.globalization.culturalformatting;

import com.ibm.rsaz.analysis.codereview.java.AbstractCodeReviewRule;
import com.ibm.rsaz.analysis.codereview.java.CodeReviewResource;
import com.ibm.rsaz.analysis.codereview.java.IRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.ast.ASTHelper;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ArgumentTypeRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.DeclaringClassRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.MethodNameRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ParameterCountRuleFilter;
import com.ibm.rsaz.analysis.codereview.java.rulefilter.ParameterTypeRuleFilter;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.rule.AbstractAnalysisRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class ParsePrimitiveRule
extends AbstractCodeReviewRule {
    private static final String CLASS = "CLASS";
    private static final String PARSE_METHOD = "PARSE_METHOD";
    private static final String STRING_CLASS = "java.lang.String";
    private static final String INT_PRIMITIVE = "int";
    private static final ParameterCountRuleFilter paramCount1 = new ParameterCountRuleFilter(1, true);
    private static final ParameterCountRuleFilter paramCount2 = new ParameterCountRuleFilter(2, true);
    private static final ArgumentTypeRuleFilter argFilter1 = new ArgumentTypeRuleFilter("java.lang.String", 0, true);
    private static final ArgumentTypeRuleFilter argFilter2 = new ArgumentTypeRuleFilter("int", 1, true);
    private static final ParameterTypeRuleFilter paramFilter1 = new ParameterTypeRuleFilter("java.lang.String", 0, true);

    public void analyze(AnalysisHistory history, CodeReviewResource resource) {
        String historyId = history.getHistoryId();
        CompilationUnit cu = resource.getResourceCompUnit();
        String fcMethodName = this.getParameter(PARSE_METHOD).getValue();
        int separatorIndex = fcMethodName.lastIndexOf(46);
        String className = separatorIndex < 0 ? this.getParameter(CLASS).getValue() : fcMethodName.substring(0, separatorIndex);
        String parseMethodName = fcMethodName.substring(separatorIndex + 1);
        DeclaringClassRuleFilter classFilter = new DeclaringClassRuleFilter(className, true);
        MethodNameRuleFilter methodFilter = new MethodNameRuleFilter(parseMethodName, true);
        IRuleFilter[] miFilters1 = new IRuleFilter[]{classFilter, methodFilter, paramCount1, argFilter1};
        List mis1 = resource.getTypedNodeList((ASTNode)cu, 32);
        ArrayList mis2 = new ArrayList(mis1);
        ASTHelper.satisfy((List)mis1, (IRuleFilter[])miFilters1);
        resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, (Collection)mis1);
        IRuleFilter[] miFilters2 = new IRuleFilter[]{classFilter, methodFilter, paramCount2, paramFilter1, argFilter2};
        ASTHelper.satisfy(mis2, (IRuleFilter[])miFilters2);
        resource.generateResultsForASTNodes((AbstractAnalysisRule)this, historyId, mis2);
    }
}

