/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.ui.operations.FileSystemUIOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.common.ISvnRepository;
import com.ibm.team.scm.svn.rcp.ui.internal.ActionDelegate;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryWrapper;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.UpdateLinksOperation;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class UpdateLinksAction
extends ActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        final UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(SVNRCPMessages.UpdateLinksAction_0, (Operation)new FileSystemUIOperation(){

            public void filesystemRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException, FileSystemClientException {
                block10: {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ITeamRepository teamRepository = UpdateLinksAction.this.getTeamRepository(context, selection, (IProgressMonitor)progress.newChild(10));
                    if (teamRepository == null) {
                        return;
                    }
                    try {
                        try {
                            ISvnClientLibrary clientLibrary = UpdateLinksAction.this.getClientLibrary(teamRepository);
                            try {
                                ISvnRepository result;
                                String errorMessage;
                                ISvnRepository repository = UpdateLinksAction.this.getSvnRepository(selection);
                                if (repository != null && (errorMessage = (result = clientLibrary.requestRevisionScan(repository, (IProgressMonitor)progress.newChild(40))).getErrorMessage()) != null && !this.handleRemoteScanFailure(teamRepository, selection, errorMessage, progress.newChild(50))) {
                                    throw new TeamRepositoryException(NLS.bind((String)SVNRCPMessages.UpdateLinksAction_6, (Object)errorMessage));
                                }
                            }
                            catch (TeamRepositoryException e) {
                                if (this.handleRemoteScanFailure(teamRepository, selection, e.getLocalizedMessage(), progress.newChild(50))) {
                                    StatusUtil.log((Object)((Object)this), (Throwable)e);
                                    break block10;
                                }
                                throw e;
                            }
                        }
                        catch (URISyntaxException e) {
                            throw new FileSystemClientException(StatusUtil.newStatus((Object)((Object)this), (String)SVNRCPMessages.UpdateLinksAction_1, (Throwable)e));
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }

            private boolean handleRemoteScanFailure(ITeamRepository teamRepository, IStructuredSelection selection2, final String errorMessage, SubMonitor progress) throws FileSystemClientException, URISyntaxException, TeamRepositoryException {
                String url;
                ISvnRepository repoRecord = this.fetchSvnRepositoryRecord(teamRepository, url = UpdateLinksAction.this.getSvnRepositoryUrl(selection2), (IProgressMonitor)progress.newChild(10));
                long startingRevision = repoRecord == null || repoRecord.getRevision() < 0L ? 0L : repoRecord.getRevision();
                UpdateLinksOperation updateOperation = UpdateLinksAction.this.createUpdateOperation(teamRepository, url, startingRevision);
                if (updateOperation == null) {
                    return false;
                }
                final boolean[] runLocal = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        runLocal[0] = MessageDialog.openQuestion(null, (String)SVNRCPMessages.UpdateLinksAction_4, (String)NLS.bind((String)SVNRCPMessages.UpdateLinksAction_5, (Object)errorMessage));
                    }
                });
                if (runLocal[0]) {
                    this.runLocalUpdate(updateOperation, repoRecord, progress);
                }
                return true;
            }

            private void runLocalUpdate(UpdateLinksOperation operation, ISvnRepository repoRecord, SubMonitor progress) throws URISyntaxException, TeamRepositoryException, FileSystemClientException {
                long latestRevision = UpdateLinksAction.this.updateWorkItemLinks(operation, (IProgressMonitor)progress.newChild(5));
                this.updateSvnRepositoryRecord(operation.getTeamRepository(), operation.getUrl(), repoRecord, latestRevision, (IProgressMonitor)progress.newChild(5));
            }

            private void updateSvnRepositoryRecord(ITeamRepository teamRepository, String url, ISvnRepository repoRecord, long latestRevision, IProgressMonitor monitor) throws TeamRepositoryException {
                ISvnClientLibrary client = UpdateLinksAction.this.getClientLibrary(teamRepository);
                if (client == null) {
                    throw new TeamRepositoryException(SVNRCPMessages.UpdateLinksAction_2);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(repoRecord == null ? 100 : 50));
                if (repoRecord == null) {
                    repoRecord = client.createRepository(url, (IProgressMonitor)progress.newChild(50));
                }
                client.updateRepositoryRevision(repoRecord, latestRevision, (IProgressMonitor)progress.newChild(50));
            }

            private ISvnRepository fetchSvnRepositoryRecord(ITeamRepository teamRepository, String url, IProgressMonitor monitor) throws TeamRepositoryException {
                ISvnClientLibrary client = UpdateLinksAction.this.getClientLibrary(teamRepository);
                if (client == null) {
                    throw new TeamRepositoryException(SVNRCPMessages.UpdateLinksAction_3);
                }
                return client.getRepository(url, true, monitor);
            }
        });
    }

    protected long updateWorkItemLinks(UpdateLinksOperation operation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        operation.runLocalUpdate(monitor);
        return operation.getLatestRevision();
    }

    protected UpdateLinksOperation createUpdateOperation(ITeamRepository teamRepository, String url, long startingRevision) {
        try {
            UpdateLinksOperation op = new UpdateLinksOperation(teamRepository, url, startingRevision);
            if (op.getLocalUpdateOperation() != null) {
                return op;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return null;
    }

    protected String getSvnRepositoryUrl(IStructuredSelection selection) throws URISyntaxException {
        Object object = selection.getFirstElement();
        if (object instanceof SvnRepositoryWrapper) {
            SvnRepositoryWrapper wrapper = (SvnRepositoryWrapper)((Object)object);
            return wrapper.getSvnRepository().getUrl();
        }
        return null;
    }

    protected ISvnRepository getSvnRepository(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof SvnRepositoryWrapper) {
            SvnRepositoryWrapper wrapper = (SvnRepositoryWrapper)((Object)object);
            return wrapper.getSvnRepository();
        }
        return null;
    }

    protected ITeamRepository getTeamRepository(UIContext context, IStructuredSelection selection, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        Object object = selection.getFirstElement();
        if (object instanceof SvnRepositoryWrapper) {
            SvnRepositoryWrapper wrapper = (SvnRepositoryWrapper)((Object)object);
            return wrapper.getRepository();
        }
        return null;
    }

    public boolean isEnabled() {
        try {
            return this.getSvnRepositoryUrl(this.getSelection()) != null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }
}

