/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.internal.filesystem.ui.picker.RepositoryCombo;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PromptForTeamRepositoryDialog
extends TitleAreaDialog {
    private RepositoryCombo repositoryCombo;
    private ITeamRepository teamRepository;
    private String url;
    private String message;
    private boolean firstTime = true;

    public PromptForTeamRepositoryDialog(Shell parentShell, String url) {
        super(parentShell);
        this.url = url;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SVNRCPMessages.PromptForTeamRepositoryDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.setTitle(SVNRCPMessages.PromptForTeamRepositoryDialog_1);
        this.message = SVNRCPMessages.PromptForTeamRepositoryDialog_2;
        this.setMessage(this.message);
        Composite repositoryArea = new Composite(composite, 0);
        repositoryArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(repositoryArea, 64);
        label.setText(NLS.bind((String)SVNRCPMessages.PromptForTeamRepositoryDialog_3, (Object)this.url));
        GridData gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 300;
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(repositoryArea, 0);
        label.setText(SVNRCPMessages.PromptForTeamRepositoryDialog_4);
        this.repositoryCombo = new RepositoryCombo(repositoryArea, WidgetFactoryContext.forDialogBox());
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getWizardPageMargins()).generateLayout(repositoryArea);
        this.repositoryCombo.getValidationStatus().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                PromptForTeamRepositoryDialog.this.updateEnablements();
            }
        });
        this.updateEnablements();
        PromptForTeamRepositoryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateEnablements();
    }

    protected void updateEnablements() {
        Object value = this.repositoryCombo.getValidationStatus().getValue();
        if (value instanceof IStatus) {
            IStatus status = (IStatus)value;
            this.setOkButtonEnablement(status.getSeverity() != 4);
            if (!status.isOK()) {
                if (!this.firstTime) {
                    this.setMessage(status.getMessage(), this.getErrorType(status));
                }
            } else if (this.repositoryCombo.getRepository() == null) {
                this.setOkButtonEnablement(false);
                this.setMessage(this.message, 0);
            } else {
                this.setMessage(this.message, 0);
            }
        } else {
            this.setOkButtonEnablement(true);
        }
    }

    protected Control createContents(Composite parent) {
        Control createContents = super.createContents(parent);
        this.firstTime = false;
        return createContents;
    }

    private void setOkButtonEnablement(boolean b) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(b);
        }
    }

    private int getErrorType(IStatus status) {
        if (status.getSeverity() == 4) {
            return 3;
        }
        if (status.getSeverity() == 2) {
            return 2;
        }
        return 1;
    }

    protected void okPressed() {
        this.teamRepository = this.repositoryCombo.getRepository();
        super.okPressed();
    }

    public ITeamRepository getTeamRepository() {
        return this.teamRepository;
    }
}

